# Installation from source

Source installations are used to develop the Claromentis software product.

This guide explains how to install Claromentis from source code using Composer & Git. It is intended for
**developers and engineers** who work closely with the Claromentis codebase.

- [Prerequisites](#prerequisites)
- [Getting started](#getting-started)
- [Install the codebase](#install-the-codebase)
- [Create the database](#create-the-database)
- [Configure the environment](#configure-the-environment)
- [Install the database schema](#install-the-database-schema)
- [Configure the web server](#configure-the-web-server)
- [Install and configure services](#install-and-configure-services)

## Prerequisites

Please review the [installation requirements](-requirements.md) before installing Claromentis.

The following software is required to install Claromentis from source. Please ensure that they are installed and
available before continuing with this guide.

- **OpenSSH** client - Pre-installed on Linux, macOS and Windows 10
- [**Git**](https://git-scm.com/book/en/v2/Getting-Started-Installing-Git) - Version control system
  - CLI, [SourceTree](https://www.sourcetreeapp.com/), [GitKraken](https://www.gitkraken.com/)
- [**Composer**](https://getcomposer.org) - Dependency manager for PHP software projects

> **Recommendation:**
> 
> The [Docker Environment](https://gitlab.com/claromentis/development/docker-environment) project satisfies all
> Claromentis installation requirements by design.
> 
> Get started with Docker today.
> [Install your very own Docker Environment](https://gitlab.com/claromentis/development/docker-environment)!

## Getting started

Only Claromentis team members have access to our proprietary source code. You'll
want to make sure that you have a gitlab.com account that has read permissions
for our [Claromentis Product Group](https://gitlab.com/claromentis/product).
Contact a senior Claromentis team member to arrange access.

You'll then need to create an SSH key for the system you're installing on and
add it to your GitLab account. SSH enables a secure connection between the
GitLab servers and the system you are using.

GitLab provides a very thorough [GitLab and SSH Keys](https://docs.gitlab.com/ee/ssh/)
guide you can follow, but here's a summary of what you'll need to do:

1. Check whether you have a `~/.ssh/id_rsa.pub` file in your home directory, skip to step 3 if so
2. Run `ssh-keygen` in your terminal, don't provide a passphrase
3. Copy the contents of `~/.ssh/id_rsa.pub` from your home directory
4. [Add it to your GitLab account](http://gitlab.com/-/profile/keys)

Home directories (`~`) can be found at the following file paths:

- Linux: `/home/<username>`
- macOS: `/Users/<username>`
- Windows: `C:\Users\<Username>`

## Clone the repository

Clone the [Claromentis Git repository](https://gitlab.com/claromentis/product/claromentis) into your workspace
directory.

Developers tend to name this directory "projects", "sites" or "workspace". For the purposes of this guide, it will be
referred to as "workspace", and be assumed to reside in your home directory (`~`).

```sh
$ cd ~/workspace
$ git clone git@gitlab.com:claromentis/product/claromentis.git
```

If you would like to install multiple versions of Claromentis separately, you can clone to multiple directories. Use
Git's `-b` option to specify the branch to checkout.

```sh
$ cd ~/workspace
$ git clone -b 9.0 git@gitlab.com:claromentis/product/claromentis.git claromentis90
$ git clone -b 8.13 git@gitlab.com:claromentis/product/claromentis.git claromentis813
```

You can clone the repository using the Git command line interface or a Git GUI such as SourceTree or GitKraken.

## Install the codebase

Use Composer to install the Claromentis codebase.

```sh
$ cd ~/workspace/claromentis
$ composer install
```

This will install Claromentis Core & Modules as Git repositories, and all of their dependencies as regular distribution
packages.

> **GitLab Personal Access Token:**
>
> If you are met with Composer's prompts for GitLab credentials, please make sure you have
> [configured your SSH key](#prerequisites) correctly.

Make sure your Git repositories cloned correctly.

- Claromentis Core will be installed into `~/workspace/claromentis/application`
- Claromentis Modules will be installed into `~/workspace/claromentis/application/web/intranet/<module>`
- Custom Modules will be installed into `~/workspace/claromentis/application/web/custom/<module>`

```sh
$ cd ~/workspace/claromentis/application
$ git status
On branch v9.0
Your branch is up to date with 'origin/v9.0'.

nothing to commit, working tree clean
```

<!-- Everything below this line should be kept in sync with distributions.md -->

## Create the database

Claromentis installations work well when an empty database is initialized in advance.

1. Connect to the MySQL or SQL Server instance
2. Create a `claromentis` database
    - MySQL: Use the `utf8mb4` character encoding and `utf8mb4_unicode_ci` collation
    - SQL Server: Use the `UTF-8` character encoding
4. Create a `claromentis` user with:
    - Full permissions granted for the `claromentis` database
    - A secure password

## Configure the environment

Environment variables are used to configure Claromentis' connections to external services.

See [Core Configuration](https://docs.claromentis.net/#/product/core/docs/technical/configuration/README?id=environment)
for the full reference of available environment variables.

1. Create a `.env` file in the **root directory** of the Claromentis installation
2. Write the following the variables to the `.env` file, replacing `<root>`, `<hostname>` and `<password>` with the
   appropriate values:
   ```env
   CLARO_DATA_DIR="<root>/data"
   CLARO_LOCAL_DATA_DIR="<root>/local_data"
   CLARO_DB_TYPE="mysql"
   CLARO_DB_HOST="<hostname>"
   CLARO_DB_NAME="claromentis"
   CLARO_DB_USER="claromentis"
   CLARO_DB_PASS="<password>"
   ```

!> **Note:**<br/>This guide describes how to use a `.env` file to configure environment variables for development systems. For production systems, it is
**highly recommended** to use real environment variables instead.

## Install the database schema

Now that the database exists and Claromentis is able to find it, we can install the Claromentis database schema.

1. Navigate to the `application` directory in the **root directory** of the installation
2. Run `./clc app:install --all --admin_password=<password> --no-interaction`

## Configure the web server

Claromentis can be served by Apache, Nginx and IIS web servers. Each needs to be configured differently in order to
serve Claromentis requests correctly.

HTTP requests should be handled like so:

1. If the requested file path **exists** at `<root>/application/web/<path>`:
   - If `<path>` is a static resource, serve it (e.g. `.css`, `.js`, `.jpg`, `.png`, `.html`, etc)
   - If `<path>` is a directory, serve the `index.php` or `index.html` within if it exists
   - If `<path>` is a PHP script, process it and serve the response (`.php`)
2. If the requested file path **does not exist** at `<root>/application/web/<path>`:
   - Forward the request to the Claromentis front controller: `<root>/application/web/index.php`
3. Set the following CGI variables before processing any PHP scripts:
   - `SERVER_NAME`: Canonical hostname
   - `SCRIPT_FILENAME`: Absolute file path of `<root>/application/web/index.php` or requested path
   - `PATH_INFO`: Requested URL path
   - `PATH_INFO_TRANSLATED`: `<SCRIPT_FILENAME><PATH_INFO>` concatenation

Below are example web server configurations that implement this request handling behaviour.

!> **Note:**<br/>This guide does not cover SSL configuration for serving Claromentis over HTTPS.

<!-- tabs:start -->

### **Apache**

Configure Apache to:

1. Allow serving files from the Claromentis `web` directory
   - `AllowOverride All` allows `.htaccess` files in the Claromentis codebase to control routing behaviour
2. Serves files from the Claromentis `web` directory for a specific hostname

Adapt the following into your `conf/httpd.conf` or `conf/httpd-vhosts.conf` Apache configuration file.

```apacheconf
<Directory "C:\Claromentis\application\web\*">
	Options All
	AllowOverride All
	Require all granted
</Directory>

<VirtualHost *:80>
    ServerAlias example.com
    VirtualDocumentRoot "C:\Claromentis\application\web"
    ErrorLog "logs/example-error.log"
    CustomLog "logs/example-access.log"
</VirtualHost>
```

### **Nginx**

Below is an annotated example Nginx server configuration from our Docker images.

1. Serve static files, falling back to the Claromentis front controller
2. Serve PHP scripts (`*.php` request URIs) using PHP-FPM via FastCGI, falling back to the Claromentis front controller
3. Serve requests using the Claromentis front controller using PHP-FPM via FastCGI

```nginx configuration
# Define the Claromentis virtual host
server {
    set $php_fpm 127.0.0.1;

    listen 80 default_server;
    server_name 127.0.0.1;

    # Document root
    root /var/www/claromentis/application/web;

    # Disable directory indexing
    autoindex off;

    # Index pages
    index index.html index.php;

    # Maximum request body size
    client_max_body_size 128M;

    # Serve static files, fall back to PHP-FPM
    location / {
        try_files $uri $uri/index.html @php-fpm;
    }

    # Serve *.php requests using PHP-FPM
    location ~ [^/]\.php(/|$) {
        # Fall back to the front controller if the script doesn't exist
        fastcgi_split_path_info ^(.+?\.php)(/.*)$;
        try_files $fastcgi_script_name @php-fpm;

        # Bypass the fact that try_files rewrites the Request URI
        # and, as a result, the value of $fastcgi_path_info
        # https://stackoverflow.com/a/67252133/1744006
        # https://trac.nginx.org/nginx/ticket/321
        set $path_info $fastcgi_path_info;

        fastcgi_pass $php_fpm:9000;
        fastcgi_index index.php;
        include fastcgi_params;
        fastcgi_param SERVER_NAME $host;
        fastcgi_param SCRIPT_FILENAME $document_root$fastcgi_script_name;
        fastcgi_param PATH_INFO $path_info;
        fastcgi_param PATH_TRANSLATED $document_root$path_info;

        # https://httpoxy.org/
        fastcgi_param HTTP_PROXY "";
    }

    # Virtual location for handling PHP-FPM front controller requests
    location @php-fpm {
        fastcgi_pass $php_fpm:9000;
        include fastcgi_params;
        fastcgi_param SERVER_NAME $host;
        fastcgi_param SCRIPT_FILENAME $document_root/index.php;

        # https://httpoxy.org/
        fastcgi_param HTTP_PROXY "";
    }

    # Omit favicon logs
    location = /favicon.ico {
        access_log off;
        log_not_found off;
    }
}
```

### **IIS**

Claromentis includes a `web.config` file in its document root directory (`application/web`) that configures IIS
automatically, but below is the expected configuration in case this feature is disabled in your environment.

1. Create an IIS Site for Claromentis
2. Configure the IIS Site to serve files from `<root>/application/web`<br/>
   ![IIS Virtual Directory configuration](iis-1.png)
3. Configure the IIS Site's URL rewrite:<br/>
   ![IIS URL Rewrite configuration](iis-2.png)
   1. Add trailing slashes for matching directories
   2. Serve the Claromentis front controller for non-matching file paths

<!-- tabs:end -->

## Install and configure services

See the [Installing and configuring services](services.md) guide to learn how to install and configure the external
services that Claromentis can utilise.