# Releases

Claromentis releases contain specific versions of Claromentis Core and Modules.

Releases are GitLab CI build artifacts that contain:

- `application` directory containing all application code
- `.env.example` file containing environment variable configuration
- `composer.json` file describing version constraints for Claromentis Core and Modules
- `composer.lock` file describing locked package versions of Claromentis Core, Modules and their dependencies
- [Docker images](docker.md) that contain all of the above, served over port 80 by Nginx and PHP-FPM

## Release process

The following steps should be followed to release a new version of Claromentis.

1. Ensure that the appropriate version branch is checked out, such as `8.12`, `8.13` or `9.0`
2. Ensure that `composer.json` requires Claromentis Core (`claromentis/framework`) and Modules at the appropriate
   version constraints
    - **Example:** For the `8.13` branch, the Core requirement should be `"claromentis/framework": "8.13.x@dev"`
3. Update the [change log](../CHANGELOG.md) as needed
4. Run `php bin/release.php <version>` where `<version>` is a patch version of Claromentis
    - **Example:** To release `8.13.0`, run `php bin/release.php 8.13.0` on the `8.13` branch

`bin/release.php <version>` is a small release script that runs the following:

1. `composer update --prefer-stable`
    - Update dependencies to the latest and most stable versions using Composer 2
3. `git add . && git commit -m "Released <version>" && git tag <version> && git push && git push origin <version>`
    - Commit, tag and push the resulting changes as a new release using Git