# Composer

Claromentis uses [Composer](https://getcomposer.org/), the de-facto package manager for PHP, to manage its PHP software
dependencies.

Using the [Claromentis Composer Installer Plugin](https://gitlab.com/claromentis/product/composer-installer), Composer
can use a single `composer.json` file to install a complete Claromentis codebase. This is the fundamental premise and
purpose of the [Claromentis](https://gitlab.com/claromentis/product/claromentis) software project.

This documentation assumes a basic understanding of how to use Composer, and explains how we use it throughout our
software projects.

See [Composer's documentation](https://getcomposer.org/doc/) to learn more about Composer.

## Example version constraints

| Example constraint             | Equivalent constraints                           | Description                                   |
|--------------------------------|--------------------------------------------------|-----------------------------------------------|
| `9.0.0`                        | `9`, `9.0`                                       | Exact version                                 |
| `^9.0`                         | `^9`, `^9.0.0`, `>=9.0.0 <10.0.0`, `9.x`, `~9.0` | Semantic version                              |
| `^9.0@dev`                     | `^9.0@dev`                                       | Semantic version with `dev` minimum stability |
| `9.0.x-dev`                    | `v9.0.x-dev`                                     | Version branch                                |
| `dev-branch-name`              |                                                  | Branch                                        |
| `dev-branch-name as 9.0.1`     |                                                  | Branch with exact version alias               |
| `dev-branch-name as 9.0.x-dev` |                                                  | Branch with version branch alias              |

> **Note:**
>
> The `v*` prefix is **optional** for semantic versions and version branches.
>
> For example, `^v9.0` is equivalent to `^9.0`, and `v9.0.x-dev` is equivalent to `9.0.x-dev`.

See [Composer's Versions and constraints documentation](https://getcomposer.org/doc/articles/versions.md) to learn more
about Composer version constraints.

See [Composer's Aliases documentation](https://getcomposer.org/doc/articles/aliases.md) to learn more about using
aliases with Composer version constraints.

## Anatomy of a Claromentis `composer.json` file

A Claromentis `composer.json` file consists of a few key features:

- **[Repositories](https://getcomposer.org/doc/05-repositories.md):** Where to find Composer packages, the default being https://packagist.org
- **[Requirements](https://getcomposer.org/doc/01-basic-usage.md#the-require-key):** Which Composer packages to install, and their [version constraints](https://getcomposer.org/doc/articles/versions.md)
- **[Config](https://getcomposer.org/doc/06-config.md):** Package configuration

See the annotated `composer.json` excerpt below to see how these are defined in practice.

> **Note:** The example below is annotated with comments, which is not valid JSON, so do not copy this and try to use
> it in practice. It will not work!

```jsonc
{
  // Project metadata
  "name": "claromentis/claromentis",
  "type": "project",
  "license": "proprietary",
  "description": "Claromentis Digital Workplace",
  // Additional Composer repositories to find packages from, besides https://packagist.org
  // Our own Claromentis Composer Repository is canonically https://packages.claromentis.net
  "repositories": [
    {
      "type": "composer",
      "url": "https://packages.claromentis.net"
    }
  ],
  "require": {
    // Platform version constraint for PHP; installation will fail if you run
    // `composer install` or `composer update` with the incorrect PHP version
    "php": "7.4.x",
    // The Claromentis Composer Installer Plugin is used to install Claromentis Core
    // and Claromentis modules in the correct directories when you run `composer install`
    // or `composer update` commands
    "claromentis/composer-installer-plugin": "^2.0@dev",
    // Claromentis Core is the foundation of the Claromentis product
    "claromentis/framework": "^9.0@dev",
    // Claromentis modules are modular Composer packages that add applications,
    // components, and other functionality to the product
    "claromentis/anniversary": "^3.0@dev",
    "claromentis/announcements": "^2.0@dev",
    "claromentis/assets": "^3.0@dev",
    "claromentis/audit": "^3.0@dev",
    "claromentis/badges": "^2.0@dev",
    "claromentis/buttons": "^2.0@dev",
    // ...
    // Different types of version constraints can be used to install development branches
    // Here is an example of aliasing a development branch to a version branch of Pages
    "claromentis/pages": "dev-bugfix/page-load_BT-123456 as v3.0.x-dev",
    // Aliases are only strictly required when other packages depend on a specific version
    // of the requirement package; otherwise you can leave it out relatively safely
    "claromentis/quiz": "dev-feature/mandatory-questions_QUIZ-789"
    // ...
  },
  // Development dependencies; only required during development, excluded from installation
  // with the `--no-dev` flag when used with `composer install` or `composer update`
  "require-dev": {
    // ...
    "phpunit/phpunit": "^7.5.20",
    // ...
  },
  // Development autoload configuration
  "autoload-dev": {
    "psr-4": {
      "Claromentis\\Core\\Tests\\": "application/web/intranet/core/tests",
      "Claromentis\\People\\Tests\\": "application/web/intranet/people/tests",
      "Claromentis\\Infocapture\\Tests\\": "application/web/intranet/infocapture/tests",
    }
  },
  // Configuration for Composer and its plugins
  "config": {
    // Allow specific Composer plugins to run
    "allow-plugins": {
      "kylekatarnls/update-helper": false,
      "ocramius/package-versions": true,
      "claromentis/installer-composer-plugin": true,
      "claromentis/composer-installer-plugin": true
    },
    // Ensure that Claromentis packages are installed as Git repositories by
    // default, for development. Use the `--prefer-dist` flag with `composer install`
    // or `composer update` to prefer distribution archives instead.
    "preferred-install": {
      "claromentis/*": "source",
      "*": "dist"
    },
    "vendor-dir": "application/vendor_core"
  },
}
```

## Resolving `composer.lock` merge conflicts

When merging branches of a project that maintains a `composer.lock` file, you may encounter merge conflicts.

[Composer's Resolving merge conflicts documentation](https://getcomposer.org/doc/articles/resolving-merge-conflicts.md)
offers a number of approaches to resolving such conflicts, but below is our process for Claromentis projects.

### 1. Reset `composer.lock`

Reset the `composer.lock` file to what it was before the merge.

```shell
git checkout <current-branch> -- composer.lock
```

Replace `<current-branch>` with your current branch; the target branch of the merge.

### 2. Resolve `composer.json` conflicts

Resolve conflicts in the `composer.json` file and stage the changes with Git when you're done.

```shell
git add composer.json
```

Usually, the conflicts revolve around package requirements that have been added or removed, or their version constraints
have changed. **Take note of the affected packages for the next step.**

### 3. Update the packages that changed

Update only the Composer packages that changed in the `composer.json` file, from the previous step, to update the lock
file accordingly.

```shell
composer update acme/package foo/bar
```

- Ensure that you only update the packages that were added, updated, or removed
- Ensure that you are running the correct version of Composer for the project when doing so

### 4. Finish the merge

You have now resolved conflicts for `composer.json` and `composer.lock`, and should be able to head on your merry way
to a successful merge!
