# Docker

Claromentis is available as a Docker image from our Docker Container Registry on GitLab.

Claromentis Docker images are self-contained Claromentis instances using [Nginx](https://www.nginx.com/) and
[PHP-FPM](https://www.php.net/manual/en/install.fpm.php), running on [Alpine Linux](https://alpinelinux.org/).

Images are built for every branch and tag in the Claromentis repository. Port 80 is exposed for HTTP ingress.

| Resource          | URL                                                                   |
|-------------------|-----------------------------------------------------------------------|
| Docker image name | `registry.gitlab.com/claromentis/product/claromentis`                 |
| Available tags    | https://gitlab.com/claromentis/product/claromentis/container_registry |

## Quick start

The Claromentis Docker image can run out of the box using SQLite and no other services.

First, authenticate with the GitLab Container Registry using your GitLab username and a
[GitLab Personal Access Token](https://gitlab.com/-/profile/personal_access_tokens) as the password.

```shell
docker login registry.gitlab.com
```

Create a Claromentis container, replacing `<password>` with the desired administrator user password.

```shell
docker run -it --rm --name=claromentis --env CLARO_DB_TYPE=sqlite --env CLARO_ADMIN_PASSWORD=claromentis --env CLARO_FF_SEED=1 -p 80:80 registry.gitlab.com/claromentis/product/claromentis
```

Visit http://localhost in your browser and login with the `admin` username and `claromentis` password. Voila!

When you stop the container, the container and all of its data will be disposed of by Docker.

<!-- TODO: Docker Compose -->

## Usage

Claromentis Docker images can be configured using environment variables.

See [Claromentis Core Configuration](https://docs.claromentis.net/#/product/core/docs/technical/configuration/?id=environment)
for the environment variables available for Claromentis Core.

### Persistent storage

Persistent storage can be achieved by mounting a [Docker volume](https://docs.docker.com/storage/volumes/) or
[Docker bind mount](https://docs.docker.com/storage/bind-mounts/) to `/var/www/claromentis/data`.

Example mounting `/path/to/data` from the host system to `/var/www/claromentis/data` in the container:

```shell
docker run -it --rm --v /path/to/data:/var/www/claromentis/data -p 80:80 registry.gitlab.com/claromentis/product/claromentis
```

The Claromentis data volume only contains files managed by Claromentis, and not those from other services like the
database or search engine, which maintain their own persistence independently.

### PHP Configuration

Claromentis Docker images minimally build upon the [official PHP Docker containers](https://hub.docker.com/_/php),
maintained by the Docker Community.

The images already provide PHP configuration appropriate for the Claromentis product in a production environment,
including:

- Enabling required PHP extensions
- Error handling and logging
- 5 minute maximum execution and input time
- 256MB memory consumption limit
- Disabling PHP exposure via the `X-Powered-By` HTTP header
- Disabling short opening tags: `<?`
- Default character set: `UTF-8`
- 128MB POST request size limit and file upload size limit
- 20 file uploads per request
- Enable `$_ENV` superglobal (`EGPCS`)
- 24 hour session lifetime, HTTP-only session cookies

If you need to change these settings further, it is recommended to either:

- Extend the Docker image and copy a PHP configuration file at build time
- Mount a PHP configuration file at runtime

PHP configuration files are read from `/usr/local/etc/php/conf.d/*`. It is recommended to prefix your configuration file
name with `zz-*` so that is read after the majority of the defaults.

Example mounting `/path/to/php.ini` from the host system to `/usr/local/etc/php/conf.d/zz-custom.ini` in the container:

```shell
docker run it --rm --v /path/to/php.ini:/usr/local/etc/php/conf.d/zz-custom.ini -p 80:80 registry.gitlab.com/claromentis/product/claromentis
```

### Health check

Claromentis Docker images don't currently define a built-in
[`HEALTHCHECK`](https://docs.docker.com/engine/reference/builder/#healthcheck), but the Claromentis product offers two
methods of checking the system's health.

1. Healthcheck REST API endpoint at URL path `/api/healthcheck/v1/`
2. CLC command: `clc check:health --extended`

### Log rotation

Our Docker images now contain [`logrotate`](https://linux.die.net/man/8/logrotate), which is configured to rotate Nginx
log files that are older than 7 days, in order to save disk space on production systems.

For now, this needs to be run externally from the containers. Specific file paths for `logrotate`'s state file and
config file, which are included in the images, need to be specified.

Here's an example of how to run `logrotate` this with Docker's `exec` command for a container named `claromentis`:

```shell
docker exec claromentis bash -c "logrotate -f -s ~/logrotate/logrotate.status ~/logrotate/logrotate.conf"
```

## Tags

| Tag          | Description                | Stable | Production | Development |
|--------------|----------------------------|--------|------------|-------------|
| `latest`     | Claromentis latest stable. | ✔      | ✔          | ❌           |
| `10-alpha`   | Claromentis 10 alpha.      | ❌     | ✔          | ❌           |
| `9`          | Claromentis 9 stable.      | ✔      | ✔          | ❌           |
| `8`          | Claromentis 8 stable.      | ✔      | ✔          | ❌           |
| `8.13`       | Claromentis 8.13 stable.   | ✔      | ✔          | ❌           |
| `10-edge`    | Claromentis 10 edge.       | ❌      | ✔          | ❌           |
| `9-edge`     | Claromentis 9 edge.        | ❌      | ✔          | ❌           |
| `8.13-edge`  | Claromentis 8.13 edge.     | ❌      | ✔          | ❌           |

Docker tags identify images by their stable product version, or by their development branch names. Production and
development builds are available for all versions. Tags are named using a stable-first, production-first approach.

- `latest` tag (Docker's default) denotes the latest stable version of Claromentis
- `x` tags denote the latest stable patch release for a major version
- `x.y` tags denote the latest stable patch release for a minor version
- `x.y.z` tags denote stable patch releases
- `-edge` suffixes denote the **latest development version** of the **codebase** for a major or minor version (`x-edge`, `x.y-edge`)
- `-dev` suffixes denote [**development builds**](#development-builds) that include developer tooling

### Production builds

[Semantic versions](https://semver.org/) are used to tag production builds of stable minor and patch versions of
Claromentis.

The `latest` tag is equivalent to the **production build** of the **latest stable version**.

Appending the `-edge` suffix to a major version or minor version will provide a production build of the latest commit
on that branch, which is usually an unstable development version.

Appending the `-rc` suffix to a major version or minor version will provide a production build of the latest release
candidate for that version, if it exists. Release candidates are typically stable.

Appending the `-beta` or `-alpha` suffix to a major version or minor version will provide a production build of the
latest beta or alpha release for that version, if it exists. Beta and alpha versions **are not stable**.

| Branch            | Stable version tags                                        | Unstable version tags                                                           |
|-------------------|------------------------------------------------------------|---------------------------------------------------------------------------------|
| `10`              | N/A                                                        | `10-edge`, `10-alpha`                                                           |
| `9`               | `latest`, `9`, `9.0`,<br/>`9-rc`, `9.0-rc`, `9.0.0-rc3`    | `9-edge`, `9-beta`, `9.0-beta`,<br/> `9-alpha`, `9.0-alpha`, `9.0.0-alpha2`     |
| `8.13`            | `8`, `8.13`, `8.13.0`,<br/>`8-rc`, `8.13-rc`, `8.13.0-rc2` | `8.13-edge`, `8-beta`, `8.13-beta`, `8.13.0-beta2`,<br/>`8-alpha`, `8.13-alpha` |
| `feature/acme`    | N/A                                                        | `feature-acme`                                                                  |
| `improvement/foo` | N/A                                                        | `improvement-foo`                                                               |

### Development builds

Development builds of Claromentis Docker images include developer tools, such as:

- Composer 1 & 2
- Git
- Node.js, NPM, NVM
- Xdebug

They use production images as a base, so that any changes made to production builds are reflected in our development
environments.

| Branch              | Stable version tags       | Unstable version tags               |
|---------------------|---------------------------|-------------------------------------|
| `10`                | `10-dev`                  | `10-edge-dev`, `10-alpha-dev`       |
| `9`                 | `9-dev`                   | `9-edge-dev`, `9.0.0-alpha2-dev`    |
| `8.13`              | `8.13-dev`, `8.13.0-dev`  | `8.13-edge-dev`, `8.13.0-beta2-dev` |
| `feature/acme`      | N/A                       | `feature-acme-dev`                  |
| `improvement/foo`   | N/A                       | `improvement-foo-dev`               |
| `bugfix/bar_BT-123` | N/A                       | `bugfix-bar_BT-123-dev`             |

These tags are the same as the production build tags, but with `-dev` suffixed.
