# Project file structures

Documentation for the file structures of Claromentis software projects.

## Core project structure

| Asset type  | Source code  | Build target     |
|-------------|--------------|------------------|
| JavaScript  | `assets/js`  | `web/assets/js`  |
| Stylesheets | `assets/css` | `web/assets/css` |

<!-- | PHP         | `src`        | N/A              | -->

## Module project structure

| Asset type  | Source code                        | Build target                      |
|-------------|------------------------------------|-----------------------------------|
| JavaScript  | `web/intranet/<module>/assets/js`  | `web/intranet/<module>/build/js`  |
| Stylesheets | `web/intranet/<module>/assets/css` | `web/intranet/<module>/build/css` |

<!-- | PHP         | `web/intranet/<module>/src`        | N/A                               | -->

## Legacy paths

Extraneous JavaScript and CSS exists in Core and module projects currently:

- `/src/js/`
- `/web/intranet/common/`
- `/web/intranet/js/`
- `/web/interface_default/<core-module>/`
- `/web/intranet/<core-module>/`

These can be progressively migrated into the above project structures.

Inline `<script>` tags in HTML templates can be migrated on a case-by-case basis if it seems appropriate, but this is by
no means a requirement.
