# GitLab Authentication

Authenticating with GitLab is required for several tasks at Claromentis. This
document describes the various methods of GitLab authentication that we use in
different environments.

## Recommendations

| Environment  | Recommended authentication method                                                      |
|--------------|----------------------------------------------------------------------------------------|
| CI/CD        | [Access tokens](#access-tokens), [deploy keys](#deploy-keys), or [SSH keys](#ssh-keys) |
| Development  | [SSH keys](#ssh-keys)                                                                  |
| Production   | [Access tokens](#access-tokens) or [deploy keys](#deploy-keys)                         |
| QA & Testing | [SSH keys](#ssh-keys)                                                                  |

## Access tokens

GitLab **access tokens**, or **deploy tokens**, can be used to authenticate
Composer's access to GitLab. They are best suited for **production**
installations of [**Claromentis distros**](...).

There are three kinds of access tokens in GitLab:

- [**Personal access tokens**](https://docs.gitlab.com/ee/user/profile/personal_access_tokens.html)
- [**Project deploy tokens**](https://docs.gitlab.com/ee/user/project/deploy_tokens/)
- [**Group access tokens**](https://docs.gitlab.com/ee/user/group/settings/group_access_tokens.html)

We use GitLab's [**group access tokens**](https://docs.gitlab.com/ee/user/group/settings/group_access_tokens.html) to
efficiently permit read-only access to our software projects. We call them
**deploy tokens** in some cases when they're used for read-only access during
installations and upgrades.

Composer offers [some documentation](https://getcomposer.org/doc/articles/authentication-for-private-packages.md#gitlab-token)
for configuring GitLab access tokens, but this doesn't explain all of the
details we need for our own environments and use cases.

To configure Composer to use an access token:

1. Install [Git](https://git-scm.com/book/en/v2/Getting-Started-Installing-Git)
2. Use 1Password to retrieve the token from the **"Claromentis Product - GitLab
   Deploy Token"** item's password field
3. Use a text editor to open the authentication configuration file for your
   server user
   - Run `composer config --global --editor --auth` to automatically open the file in a text editor
   - Alternatively, run `composer global config home` to find the path of Composer's global home directory,
     then open `auth.json` within that path; it's usually `~/.config/composer/auth.json`
   <!-- nano $(composer global config home)/auth.json -->
4. Update the file with the appropriate configuration, replacing `<token>` with the token:
   ```json
   {
     "gitlab-token": {
       "gitlab.com": "<token>"
     }
   }
   ```

> **Note:** When installing [**Claromentis distros**](https://gitlab.com/claromentis/product/distros),
> please ensure that **Git** is installed on the server so that **Composer**
> can use it to download our custom module repositories from GitLab.
> 
> Alternatively, follow the [**offline installation guide**](installation/offline.md)
> to install Claromentis without Composer or Git.

## Deploy keys

> **TODO:** GitLab private deploy keys (**CI/CD**, Production)

## SSH keys

**SSH keys** can be used to connect securely to any Git repository, including
those hosted by GitLab. They are best suited for **development** and **testing**
environments that need read & write access to the source code of Claromentis
software projects.

GitLab provides a very thorough [GitLab and SSH Keys](https://docs.gitlab.com/ee/user/ssh)
guide that you can follow, but here's a summary of what you'll need to do:

1. Check whether you have a `~/.ssh/id_rsa.pub` file in your home directory,
   skip to step 3 if so
2. Run `ssh-keygen` in your terminal, don't provide a passphrase
3. Copy the contents of `~/.ssh/id_rsa.pub` from your home directory
4. [Add it to your GitLab account](http://gitlab.com/-/profile/keys)

Home directories (`~`) can be found at the following file paths:

- Linux: `/home/<username>`
- macOS: `/Users/<username>`
- Windows: `C:\Users\<Username>`
