# Claromentis Installation Guide

This document summarises the guides available for all Claromentis installation methods.

## Requirements

Please review the [installation requirements](-requirements.md) before installing Claromentis.

## Installation methods

Choose the installation method that suits your platform and environment.

| Installation method                                                                                                        | Description                                                                                                                | Environment                                                                                                                                             |
|----------------------------------------------------------------------------------------------------------------------------|----------------------------------------------------------------------------------------------------------------------------|---------------------------------------------------------------------------------------------------------------------------------------------------------|
| [**Docker Containers**](docker.md)                                                                                         | Install Claromentis [Docker](https://docker.com) containers.                                                               | **Production:** Modern installation method. Recommended method for QA, Staging or Production deployments.                                               |
| [**Distributions**](distributions.md)                                                                                      | Install Claromentis distributions using [Composer](https://getcomposer.org).                                               | **Production:** Legacy installation method. Use this method for environments that don't support Docker.                                                 |
| [**Offline**](offline.md)                                                                                                  | Install Claromentis distributions without using Composer or Git.                                                           | **Production:** Legacy installation method. Use this method for installing [Claromentis distributions](https://gitlab.com/claromentis/product/distros). |
| [**Docker Environment**](https://gitlab.com/claromentis/development/docker-environment/-/blob/master/docs/installation.md) | Install Claromentis using the [Docker Environment](https://gitlab.com/claromentis/development/docker-environment) project. | **Development:** Modern installation method. Use this method for contributing to Claromentis software development.                                      |
| [**Source**](source.md)                                                                                                    | Install Claromentis source code using [Composer](https://getcomposer.org) & [Git](https://git-scm.com/).                   | **Development:** Legacy installation method. Use this method for contributing to Claromentis software development.                                      |

<!--
  TODO: Developer quick-start with Docker and Git. `docker-compose up -d`, then inside containers: `composer install`.

  | **Docker Compose** | Install Claromentis using a Docker Compose project. | **Development:** Use this method for contributing to Claromentis software development. |
-->

## Upgrading from Claromentis 8.13

See the [Claromentis 9 upgrade guide](../9.0-upgrade.md) to learn about upgrading existing Claromentis 8.13 systems to
Claromentis 9.
