# Claromentis Composer Installer Plugin

[![pipeline status](https://gitlab.com/claromentis/product/composer-installer/badges/v2.0/pipeline.svg)](https://gitlab.com/claromentis/product/composer-installer/-/commits/v2.0)

A [Composer installer plugin](https://getcomposer.org/doc/articles/custom-installers.md) for
[Claromentis Core](https://gitlab.com/claromentis/product/core) and Modules.

## What's new?

Composer Installer 2 improves upon Composer Installer 1.2 in the following ways.

- Supports Composer 1 & 2, and Claromentis 8, 9 & 10
  - Faster, asynchronous, package downloads
  - Lower memory consumption
- Supports source code installations for development
- State-aware package update algorithm
  - Packages are no longer copied on top of old versions, they are instead swapped as quickly as possible
  - Stateful files, such as config files and user data, are preserved
- End-to-end automated test suite
- Backwards-compatible with legacy installations (`installer/composer.json`, `modules.json`)
- Runs event-based [Composer scripts](https://getcomposer.org/doc/articles/scripts.md) for Core and modules (e.g. `post-install-cmd`, `post-update-cmd`)
- No longer runs migrations automatically: use `./clc app:upgrade --all` for now

## Installation

### Claromentis installations

To use the Composer Installer for Claromentis installation projects:

- Use the `"project"` package type
- Use the `"https://packages.claromentis.net"` Composer repository
- Prefer source installations of Claromentis packages by default, by using Composer's `preferred-install` configuration
- Use `@dev` minimum stability suffix for Claromentis package requirements

```json
{
  "name": "claromentis/client-name",
  "type": "project",
  "repositories": {
    "type": "composer",
    "url": "https://packages.claromentis.net"
  },
  "require": {
    "claromentis/composer-installer-plugin": "^2.0.0",
    "claromentis/framework": "^9.0",
    "claromentis/pages": "*@dev"
  },
  "config": {
    "preferred-install": {
      "claromentis/*": "source",
      "*": "dist"
    }
  }
}
```

### Modules

To use the Composer Installer for a Claromentis Module:

- Use the `"claromentis-module"` package type
- Add the following to the module's `composer.json` file.

```json
{
  "name": "claromentis/my-module",
  "type": "claromentis-module",
  "repositories": {
    "type": "composer",
    "url": "https://packages.claromentis.net"
  },
  "require": {
    "claromentis/composer-installer-plugin": "^2.0",
    "claromentis/framework": "^9.0"
  }
}
```

When a Claromentis installation project installs this module, it will be installed in `web/intranet/my-module`.

### Supported package types

Specific Composer package types are supported by the Claromentis Composer Installer.

| Package type                | Installer         | Description                                                     |
|-----------------------------|-------------------|-----------------------------------------------------------------|
| `claromentis-core`          | `CoreInstaller`   | [Claromentis Core](https://gitlab.com/claromentis/product/core) |
| `claromentis-module`        | `ModuleInstaller` | Claromentis Modules                                             |
| `claromentis-custom-module` | `ModuleInstaller` | Claromentis Custom Modules                                      |
| `claromentis-framework-v8`  | `CoreInstaller`   | **[Legacy]** Claromentis Core 8.x                               |
| `claromentis-module-v7`     | `ModuleInstaller` | **[Legacy]** Claromentis 7.x and 8.x Modules                    |
| `claromentis-framework`     | `CoreInstaller`   | **[Legacy]** Claromentis Core (unused)                          |

Package types marked as **[Legacy]** were used by installer 1.x for Claromentis Core 7.x and 8.x. They are supported by
installer 2.x for backwards compatibility.

> **Note:** Internally, Composer Installer 2 normalizes legacy package types to their canonical equivalents. For
> example, `claromentis-framework-v8` is normalized to `claromentis-core`, and `claromentis-module-v7` is normalized
> to `claromentis-module`.
>
> This is to prevent Composer from [uninstalling and reinstalling a package when its package type
> changes](https://gitlab.com/claromentis/product/composer-installer/-/issues/14), and instead retain its behaviour of
> updating packages in place.
>
> This is arguably a bug in Composer, because a package type may be supported by many installers, but it is at least
> solved by this plugin by normalizing package types.

## Usage

<!-- TODO: Update this to reflect general usage, `composer require`, etc -->

Clone a version of [`claromentis/claromentis`](https://gitlab.com/claromentis/product/claromentis) and run
`composer install`. The installer plugin will be installed first, and proceed to install Claromentis Core and Modules
after all of their dependencies.

### Source code

```
cd /path/to/claromentis
composer install
```

### Production code

```
cd /path/to/claromentis
composer install --prefer-dist --no-dev
```

### Legacy versions

The installer is run from within Claromentis Core's `installer` directory for 7.4.x and 8.x.

```
cd /path/to/claromentis/application
composer -d installer update claromentis/* --prefer-dist --no-dev
```

## Configuration

The Composer installer can be configured in the `composer.json` of the root project that Composer is used from.

Configuration for the installer is read from `config.claromentis.installer`.

> **TODO:** Claromentis Module root projects will not use the configuration. Their dependencies will be installed to
> their `vendor-dir` as if they were regular Composer libraries.

<!-- TODO: We could symlink from `vendor/claromentis/framework/web/intranet/<module-name>` to the project root, and
configure modules to run automated tests from there. -->

### Example configuration

```json
{
  "name": "vendor/my-claromentis-project",
  "type": "project",
  "repositories": [
    {
      "type": "composer",
      "url": "https://packages.claromentis.net"
    }
  ],
  "require": {
    "claromentis/composer-installer-plugin": "^2.0.0",
    "claromentis/core": "^9.0@dev",
    "claromentis/pages": "*",
    "claromentis/custom/skeleton": "*"
  },
  "config": {
    "claromentis": {
      "installer": {
        "backups": true,
        "paths": {
          "backups": "backups",
          "core": "core",
          "modules": "modules",
          "custom": "modules/custom"
        },
        "migrations": true
      }
    },
    "preferred-install": {
      "claromentis/*": "source",
      "*": "dist"
    }
  }
}
```

### Configuration variable reference

Composer Installer configuration resides in `composer.json` under `config.claromentis.installer`. Variables mentioned
below assume this prefix.

| Variable        | Type     | Default value                | Description                                                                            |
|-----------------|----------|------------------------------|----------------------------------------------------------------------------------------|
| `backups`       | `bool`   | `false`                      | Backups of known stateful paths when `true`.                                           |
| `paths.backups` | `string` | `"backups"`                  | Backups path for stateful packages updated by the plugin.                              |
| `paths.core`    | `string` | `"application"`              | Installation path for [Claromentis Core](https://gitlab.com/claromentis/product/core). |
| `paths.module`  | `string` | `"application/web/intranet"` | Installation path for Claromentis Modules.                                             |
| `paths.custom`  | `string` | `"application/web/custom"`   | Installation path for Claromentis Custom Modules.                                      |
| `migrations`    | `bool`   | `false`                      | **TODO #5:** Run migrations after all packages have been installed.                    |

- All backups will take place before each package installation or update
- All installation paths **must** be relative to the root project
- **Default** installation paths vary per root project type
- Module installation paths **may** lie within the Core installation path; they will be treated as stateful paths and be retained when Core is updated

## Tests

Automated tests ensure that key behaviours of the plugin work as expected when installing and updating Claromentis
packages using Composer.

Tests can be run with PHPUnit after installing project dependencies:

```bash
$ composer install
$ composer test
```

To run individual suites:

- `composer test:unit` runs unit tests only
- `composer test:system` runs system tests only

To clear the testbed directory used by system tests:

- `composer test:clear`

### System test suite

The system test suite includes end-to-end tests that verify the plugin's ability to download, install and update
Claromentis packages from our Composer repository (https://packages.claromentis.net) and Git repositories using Composer
1 and 2.

Their external system dependencies make them inherently fragile and slow, but provide valuable insight into the
successfulness of Claromentis installations that use Composer and, ultimately, the successfulness of the plugin.

The following related services and projects are **required** to be available for these tests to work correctly.

| Project                                                                      | Service URL                      | Description                                                                                                                                                                                              |
|------------------------------------------------------------------------------|----------------------------------|----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------|
| [Satisfactory](https://gitlab.com/claromentis/product/services/satisfactory) | https://packages.claromentis.net | Claromentis Composer Repository.<br/>Builds, catalogues, stores and serves Claromentis software packages for use with Composer.                                                                          |
| [Claromentis](https://gitlab.com/claromentis/product/claromentis)            |                                  | Claromentis Digital Workplace.<br/>Composer project that brings together Claromentis Core & Modules.<br/>`composer install` and `composer update` are tested for this project primarily.                 |
| [Claromentis Core](https://gitlab.com/claromentis/product/core)              |                                  | Claromentis Core.<br/>Core software project and framework.<br/>Legacy installations rely on `composer update -d installer` for this project, and compatibility with this legacy approach is tested here. |
| [Claromentis Modules](https://gitlab.com/claromentis/product)                |                                  | Claromentis Modules.<br/>Core software modules that provide applications and components to Claromentis Core.                                                                                             |

System tests **expect** the following command-line programs to be available:

| Name     | Command     | Version |
|----------|-------------|---------|
| Composer | `composer`  | 2       |
| Composer | `composer1` | 1       |
| Git      | `git`       | 2       |

## How it works

Claromentis Composer Installer Plugin is a Composer plugin that provides installers for Claromentis Core & Modules. It
ensures that Composer installs Claromentis code with the correct file structure.

It uses the [Composer API](https://getcomposer.org/doc/articles/custom-installers.md) to handle the installation of
Claromentis Composer packages.

### Installers and package types

Composer installer plugins declare which packages they can install by comparing the
[Composer package types](https://getcomposer.org/doc/04-schema.md#type) of every package that needs to be installed.

Claromentis Core and Modules are identified by their Composer package types, such as `claromentis-core`,
`claromentis-module` or `claromentis-custom-module`. See [Supported package types](#supported-package-types).

Each installer provided by the plugin takes responsibility for specific Composer package types.

- The `CoreInstaller` installs and updates Claromentis Core
- The `ModuleInstaller` installs and updates Claromentis Modules and Custom Modules

Claromentis package installers inherit common behaviour from a base installer
that handles updating stateful packages for legacy versions of Claromentis.
See [Stateful updates](#stateful-updates).

### Installation paths

Installation paths are configurable within the `composer.json` of the root project using Composer with the plugin.
See [Configuration](#configuration).

The plugin supports installing Claromentis Modules and other vendor packages inside the Claromentis Core installation
directory, also known as the "application" directory.

Default file structure:

```
- application
  - web
    - custom
      - custom1
      - custom2
      - custom3
    - intranet
      - module1
      - module2
      - module3
- backups
- vendor
  - vendor1
    - package1
    - package2
  - vendor2
    - package3
    - package4
```

[Claromentis](https://gitlab.com/claromentis/product/claromentis) configures its vendor directory to
`application/web/vendor_core` for backwards-compatibility with Claromentis Core 8.x and Composer Installer Plugin 1.x.

_Non-intersecting_ file structures are equally supported, but Claromentis Core would need to support loading module and
vendor code, as well as serving static assets, from other paths. This would enable highly parallel code installations.

```
- backups
- core
- modules
  - custom
    - custom1
    - custom2
    - custom3
  - module1
  - module2
  - module3
- vendor
  - vendor1
    - package1
    - package2
  - vendor2
    - package3
    - package4
```

See the following issue for more information about addressing this in Claromentis Core:

- [FRAM-579 Move modules from `/web/intranet` to `/modules`](https://claromentis.atlassian.net/browse/FRAM-579)

### Backups

Packages can be backed up during package updates. See [Configuration](#configuration).

Enabling backups will instruct the installer to backup known stateful paths to `backups/<vendor/package>.<timestamp>`,
relative to the project root. See [Stateful updates](#stateful-updates) for the list of known stateful paths.

> **Note:** When using Composer 1, or when Composer Installer 2 is first installed/updated, the configured `vendor`
> directory will not be backed up pristinely if it resides within the Claromentis Core application directory
> (e.g. `application/vendor_core`), which it does by default.
> 
> This is due to the way Composer's package dependency resolution works, which is out of our control prior to the plugin
> being installed.

### Stateful updates

When installing or updating installations of Claromentis Core & Modules - i.e. those listed in
`<vendor>/composer/installed.json` - the Composer Installer will try to retain any known stateful file paths (file paths
containing user data) of those packages.

Stateful paths that are retained during updates, and [backed up when backups are enabled](#backups), are as follows:

- **Claromentis Core**
  - `.env`
  - `data`
  - `local_data`
  - `modules.json`
  - `web/appdata`
  - `web/custom`
  - `web/intranet/common/config.php`
- **Claromentis Modules and Custom Modules**
  - `config_<module-name>.php`

This behaviour is primarily to safely support Claromentis 8. Claromentis 9 has a stateless application directory by
default, and storing application state alongside its codebase is otherwise **highly discouraged**.

### 8.x and 9.x compatibility

> **TODO**

### Installation discovery

**Installation discovery** is a potential future feature of the installer plugin. It would allow updating an existing
Claromentis installation that _wasn't_ installed with the Composer Installer plugin, or was installed using a different
or lost vendor directory. It would work by detecting `composer.json` and `_init/version.txt` files to ascertain the
currently installed Claromentis Core and Module versions.

This feature was cut from the stable release of Composer Installer 2 because it was deemed unnecessary. If you have a
need for this feature, please mention @chris.andrew in a comment on
[the GitLab issue](https://gitlab.com/claromentis/product/composer-installer/-/issues/15), or
[the Jira issue](https://claromentis.atlassian.net/browse/FRAM-372).