<?php

namespace Claromentis\Composer;

/**
 * Promise dummy for Composer 1.
 *
 * Acts like (shaped like) a promise in place of React's promise system used in Composer 2.
 *
 * @see \React\Promise\PromiseInterface
 */
class Promise /*implements \React\Promise\PromiseInterface (kind of)*/
{
	/**
	 * Immediately invokes the given callable.
	 *
	 * @param callable|null $onFulfilled
	 * @return null Always returns null
	 */
	public function then(callable $onFulfilled = null)
	{
		if ($onFulfilled) {
			$onFulfilled();
		}

		return null;
	}
}