<?php

namespace Claromentis\Composer;

use Composer\Package\Package;
use Composer\Package\PackageInterface;
use Composer\Repository\InstalledRepositoryInterface;

/**
 * Claromentis library installer.
 *
 * Installs libraries with public facing assets to `web/lib`.
 *
 * @author Chris Andrew <chris.andrew@claromentis.com>
 */
class LibraryInstaller extends ModuleInstaller
{
	public function supports($packageType): bool
	{
		return $packageType === 'claromentis-library';
	}

	public function getInstallPath(PackageInterface $package): string
	{
		return $this->util->joinPath($this->getLibraryInstallPath(), $this->getProjectName($package));
	}

	/**
	 * Get the installation path for Claromentis libraries.
	 *
	 * This can be configured in the root project's `composer.json`, and defaults to `'application/web/lib'`, or
	 * `'../web/lib'` for legacy installations.
	 *
	 * This must **always** be a path relative to the root project directory, with slashes and whitespace trimmed.
	 *
	 * @return string
	 */
	public function getLibraryInstallPath(): string
	{
		$rootConfig = $this->composer->getPackage()->getConfig();

		return $rootConfig['claromentis']['installer']['paths']['library']
			?? $this->util->joinPath($this->getCoreInstallPath(), 'web', 'lib');
	}

	public function getStatefulPaths(PackageInterface $package): array
	{
		return [];
	}

	public function copyStatefulPackageFiles(
		PackageInterface             $package,
		string                       $sourcePath,
		string                       $targetPath,
		InstalledRepositoryInterface $installedRepository = null
	): void {
		// No-op
	}

	public function copyVendor(PackageInterface $package, string $targetPath, string $sourcePath = null): void
	{
		// No-op: libraries will not contain vendor
	}

	public function shouldBackup(PackageInterface $package): bool
	{
		return false;
	}

	public function normalizePackageType(Package $package): void
	{
		// No-op
	}
}
