# Composer Installer Plugin Change log

## 2.1.0 - 1st September 2025

- !7 FRAM-1088 Implemented Composer script registration for Core and modules when they are installed or updated
- !7 FRAM-1038 Preliminary support for PHP 8

## 2.0.4 - 31st October 2023

- Fixed incompatibility with Composer 2.6 and [`react/promise`](https://github.com/reactphp/promise) 3.x
- Updated Composer dependencies (Composer from 2.3.4 to 2.6.5) for automated tests
- Removed ghosts and ghouls

## 2.0.3 - 16th May 2022

- Allowed Claromentis Module root packages to install Claromentis Core in their `vendor` directory

## 2.0.2 - 3rd May 2022

- Restored `claromentis/composer-installer-plugin` package name
  - `claromentis/installer-composer-plugin` is now:
    - Available from Satisfactory (https://packages.claromentis.net/#installer)
      - Up to 2.0.1
      - Built from a read-only fork: https://gitlab.com/claromentis/product/installer-composer-plugin
    - Available from Packagist (https://packagist.org/packages/claromentis/installer-composer-plugin)
      - Up to 1.2.8
      - Built from: https://github.com/Claromentis/installer-composer-plugin

## 2.0.1 - 3rd May 2022

- Renamed package from `claromentis/composer-installer-plugin` back to `claromentis/installer-composer-plugin` for legacy compatibility

## 2.0.0 - 11th April 2022

- \#15 Implemented heuristic installation discovery for source installations of Claromentis packages

## 2.0.0-beta - February 24th 2022
- \#2 Improved package backup behaviour
  - Core backups should be pristine when using Composer 2, and pristine except for the configured vendor directory when using Composer 1
- \#2 Implemented support for uninstalling Claromentis packages safely
  - Uninstallation should retain any stateful files
- \#12 Implemented automated tests for stateful file retention and uninstallation
- \#12 Added support for `--verbose`/`--debug` PHPUnit flags to use Composer's debug output
- \#13 Fixed long branch names causing exceedance of the default Windows file path length limit
- \#14 Implemented Claromentis Composer package normalization to improve Composer's update behaviour when package type names change
- Implemented vendor binary installation support for Claromentis packages in case any include them in future
- Fixed numerous edge-case bugs when installing and upgrading Claromentis packages
- Fixed Claromentis module packages not retaining config files after updating or uninstalling
- Improved logging

## 2.0.0-alpha11 - 18th November 2021
- Fixed Core `dev-` branches using Core 7.x installation paths

## 2.0.0-alpha10 - 30th September 2021
- !2 \#8 FRAM-596 Implemented support for [Composer 2](https://blog.packagist.com/composer-2-0-is-now-available/)
  - Backwards-compatible with Composer 1
  - \#3 Supports legacy installer/composer.json installations
  - \#12 Implements initial system test suite for Claromentis installations; automated end-to-end tests
  - \#2 Initial support for package backups (currently vendor-inconsistent)

## 2.0.0-alpha9 - 22nd July 2021
- \#11 Fixed Composer Installer removing itself during fresh installations
  - Removed automatic update re-run; it causes too many problems, including uninstalling the installer itself when run after a `composer install`
- Removed dependency processing from the plugin's initialisation step; this would slow down many Composer commands unnecessarily

## 2.0.0-alpha8 - 16th February 2021
- \#9 Fixed issues with dependency processing when installing Claromentis Core development branches from source

## 2.0.0-alpha7 - 11th February 2021
- Included development branches/versions of Claromentis Core when processing package dependencies
- \#2 Implemented initial application directory backups
- Minor package processing optimisation and logging improvements

## 2.0.0-alpha6 - 12th January 2021
- Fixed `preg_replace` error when removing custom module name prefixes
- Fixed errors and inconsistencies when rerunning Composer `install`s/`upgrade`s in some situations
- Initial untested support for Claromentis Core 7.x

## 2.0.0-alpha5 - 11th January 2021
- Implemented customizable module installation paths
- Modules prefixed with `claromentis/custom/` will have `custom/` stripped from their installation directory
- Implemented rerunning Composer `install`s/`upgrade`s when the plugin is updated
- Updated readme documentation

## 2.0.0-alpha4 - 8th January 2021
- \#7 Initial support for `composer install` from Claromentis Module root packages
- Implemented rerunning Composer `install`s/`upgrade`s when the plugin has first been installed

## 2.0.0-alpha3 - 6th January 2021
- Added `web/intranet/common/config.php` to stateful path list
- Modules prefixed with `claromentis/custom-` will have `custom-` stripped from their installation directory
- \#9 Initial support for Claromentis 8 source installations with dependencies

## 2.0.0-alpha2 - 14th July 2020
- Rewrote installer using a new algorithm

## 2.0.0-alpha - 18th December 2019
- Removed execution of Phing migrations after installation

## 1.2.5 - 10th July 2019
- Updated explicit symfony/polyfill-ctype dependency from 1.10.0 to 1.11.0 to allow Core 8.8.0+ to be installed

## 1.2.4 - 2nd April 2019
- Added explicit symfony/polyfill-ctype dependency to avoid conflicts with Core 8.6.0+

## 1.2.3 - 6th April 2016
- Fixed not registering updates for packages installed from git

## 1.2.2 - 5th April 2016
- Removing contents of _init folder before applying new update - ensures that no migrations are left from earlier versions

## 1.2.1 - 3rd March 2016
- Fixed detecting return code of phing task on Windows (was preventing "retry with upgrade" introduced in 1.0.7)
- Removed fake local repository used for source installation as it's not working as should
- Added this change log

## 1.2.0 - 28th January 2016
- Changed the flow to run phing tasks after autoloader has been created

## Versions 1.1.1...1.1.6 - 22nd December 2015 to 27th January 2016
- Various bugfixes, including one BC break

## 1.1.0 - 21st December 2015
- Initial release with support installation Claromentis 8 and modules

## 1.0.10 - 15th December 2015
- Fixed "build.xml doesn't exist" when installing a module for Cla 8

## 1.0.9 - 16th June 2015
- Changed composer API dependency to be less strict

## 1.0.8 - 25th March 2015
- Added support for installing modules from source code from git

## 1.0.7 - 24th March 2015
- Not failing hard if application already installed - trying upgrade instead

## 1.0.6 - 4th March 2015
- Improved reliability by adding custom error handler to prevent warnings from aborting installation

## 1.0.5 - 4th March 2015
- First real release
