if (typeof countdownTimerEvent === 'undefined') {
	countdownTimerEvent = {};
}

define(['jquery'], function($) {

    const MODE_DOWN = 1;
    const MODE_UP = 2;
	/**
	 * Initialise the countdown component content for display.
	 */
	function countdownInit(component_id, countdown_seconds, has_description, show_days, show_hours, show_minutes, show_seconds, text_colour, bg_type, bg_colour, bg_image, bg_image_size, has_text_zero, link, link_newwindow, show_shadow, mode, timezone, hasTimePassed) {
		// If we've already got a timer running for this component
		// stop it so we don't have multiple timers and consequently
		// countdowns running.
		if (countdownTimerEvent[component_id]) {
			clearTimeout(countdownTimerEvent[component_id]);
		}

		// If there's no description remove the enclosing tag.
		if (!has_description) {
			$(component_id + ' .description').remove();
		}

		var last_unit = null;

		if (!show_days) {
			$(component_id + ' .days').css('display', 'none');
		} else {
			last_unit = 'days';
		}

		if (!show_hours) {
			$(component_id + ' .hours').css('display', 'none');
		} else {
			last_unit = 'hours';
		}

		if (!show_minutes) {
			$(component_id + ' .minutes').css('display', 'none');
		} else {
			last_unit = 'minutes';
		}

		if (!show_seconds) {
			$(component_id + ' .seconds').css('display', 'none');
		} else {
			last_unit = 'seconds';
		}

		// Seconds don't have a separator after them before they're the last unit
		// to be displayed (normally). If seconds aren't displayed, hide the
		// separator of the last unit to be used.
		if (last_unit !== null && last_unit !== 'seconds') {
			$(component_id + ' .' + last_unit + ' .separator').css('display', 'none');
		}

		if (text_colour) {
			$(component_id).css('color', text_colour);
		}

		// You can only have a background colour or image.
		if (bg_type === 1 && bg_colour) {
			$(component_id).css('background-color', bg_colour);
		} else if (bg_type === 2 && bg_image) {

            $(component_id).css('background-image', 'url("' + bg_image + '")');

			switch(bg_image_size) {
				case 1:
					$(component_id).css('background-size', 'cover');
					break;
				case 2:
					$(component_id).css('background-size', 'contain');
					break;
				default:
				// Display background image in actual size.
			}
		}

		if (!show_shadow) {
			$(component_id).addClass('hide-shadow');
		}

		// If there's no description remove the enclosing tag.
		if (!has_text_zero) {
			$(component_id + ' .text_zero').remove();
		}

		if (link) {
			$(component_id + ' a.link').attr('href', link);
		} else {
			// Disable the click event if we've got no link so
			// clicking it doesn't go to the top of the page.
			$(component_id + ' a.link').click(function(e) {
				e.preventDefault();
			});
		}

		if (link_newwindow) {
			$(component_id + ' a.link').attr('target', '_blank');
		}

		// Get a current timestamp. The difference in timezone between PHP and JS
		// doesn't matter as we're just going to compare two JS timestamps to get
		// the countdown to tick over.
		var start_obj = new Date();
		var start_time = start_obj.getTime();

		// Display the countdown without delay.
		displayCountdown(component_id, countdown_seconds, start_time, show_days, show_hours, show_minutes, show_seconds, has_text_zero, show_shadow, mode, timezone, hasTimePassed);

		// Start a timer to update and display the countdown every second.
		var timerId = setInterval(function(){
			displayCountdown(component_id, countdown_seconds, start_time, show_days, show_hours, show_minutes, show_seconds, has_text_zero, show_shadow, mode, timezone, hasTimePassed);
		}, 1000);

		// Store the id for the timer so we can stop it when required.
		countdownTimerEvent[component_id] = timerId;
	}

	/**
     * Calculate how much time is left on the countdown and display it.
     *
     * @param component_id
     * @param countdown_seconds
     * @param start_time
     * @param show_days
     * @param show_hours
     * @param show_minutes
     * @param show_seconds
     * @param has_text_zero
     * @param show_shadow
     * @param mode
     * @param timezone
     * @param hasTimePassed
     */
	function displayCountdown(component_id, countdown_seconds, start_time, show_days, show_hours, show_minutes, show_seconds, has_text_zero, show_shadow, mode, timezone, hasTimePassed) {
        var now_obj = new Date().toLocaleString("en-US", { timeZone: timezone });
        now_obj = new Date(now_obj);
		var now_time = now_obj.getTime();

		// Adjust for timezone
		var target_time = new Date(start_time).toLocaleString("en-US", { timeZone: timezone });
		var target_time_obj = new Date(target_time);
		var target_time_ms = target_time_obj.getTime();

		// Calculate the difference between the time now and the countdown.
		var time_difference = Math.round((now_time - target_time_ms) / 1000);
		var seconds_left;

		var isModeModified = false;

        // MODE UP
		if (mode === MODE_UP) {
			if (countdown_seconds < 0)
			{
                isModeModified = true;
				countdown_seconds *= -1;
				mode = MODE_DOWN;
				seconds_left = countdown_seconds - time_difference;

			} else if (countdown_seconds >= time_difference && hasTimePassed === 0)
            {
				// Time is set to future, switch to mode 1 temporarily
				isModeModified = true;
				mode = MODE_DOWN;
				seconds_left = countdown_seconds - time_difference;

            // reset timers case when counter goes from -0:00:01 to 0:00:1 without refresh page (hasTimePassed is not updated)
            } else if (countdown_seconds < time_difference && hasTimePassed === 0) {
                seconds_left = time_difference - countdown_seconds;

            // Start counting up after reaching the given time
            } else
            {
                seconds_left = time_difference + countdown_seconds;
            }

        // MODE DOWN
        } else
        {
			seconds_left = countdown_seconds - time_difference;
		}

		var reducer = null;
		var days_left = null;
		var hours_left = null;
		var minutes_left = null;

        // Mode "down" and no time left
		if (mode === MODE_DOWN && seconds_left < 0) {
			// There's no time left to countdown so stop the timer.
			clearTimeout(countdownTimerEvent[component_id]);

			// If there's text to display instead of a zero countdown display it.
			if (has_text_zero) {
				$(component_id + ' .description').remove();
				$(component_id + ' .digit-wrap').remove();
				$(component_id + ' .text_zero').css('display', 'block');
			}

			// Change back to mode 2 if it was switched from mode 2
			if (mode === MODE_DOWN && countdown_seconds > time_difference) {
				mode = MODE_UP;
			}
		} else {
            // don't mess with negative seconds number
            if (mode === MODE_UP)
                seconds_left = Math.abs(seconds_left);

            // Calculate the number of days left.
			if (show_days) {
				reducer = 24 * 60 * 60;

                days_left = Math.floor(seconds_left / reducer);
				seconds_left = seconds_left - (Math.abs(days_left) * reducer);
            }

			// Calculate the number of hours left.
			if (show_hours) {
				reducer = 60 * 60;
				hours_left = Math.floor(seconds_left / reducer);
				seconds_left = seconds_left - (hours_left * reducer);
			}

			// Calculate the number of minutes left.
			if (show_minutes) {
				reducer = 60;
				minutes_left = Math.floor(seconds_left / reducer);
				seconds_left = seconds_left - (minutes_left * reducer);
			}

			// Pad out the hours, minutes and seconds for display.
			if (hours_left !== null && hours_left < 10) {
				hours_left = '0' + hours_left.toString();
				hours_left = hours_left.substr(hours_left.length - 2);
			}

			if (minutes_left !== null && minutes_left < 10) {
				minutes_left = '0' + minutes_left.toString();
				minutes_left = minutes_left.substr(minutes_left.length - 2);
			}

			if (seconds_left !== null && seconds_left < 10) {
				seconds_left = '0' + seconds_left.toString();
				seconds_left = seconds_left.substr(seconds_left.length - 2);
			}

			$(component_id + ' .days_left').text(days_left);
			$(component_id + ' .hours_left').text(hours_left);
			$(component_id + ' .minutes_left').text(minutes_left);
			$(component_id + ' .seconds_left').text(seconds_left);

			if (isModeModified) {
				mode = MODE_UP; // Revert back to original mode
			}

            // prefix with minus if isModeModified is true
            if (isModeModified && hasTimePassed === 0)
                $(component_id + ' .unit-sign').text('-');
            else
                $(component_id + ' .unit-sign').text('');
		}

		// Schedule the next update if there's time left
		if (seconds_left > 0) {
			countdownTimerEvent[component_id] = setTimeout(function() {
				displayCountdown(component_id, countdown_seconds, start_time, show_days, show_hours, show_minutes, show_seconds, has_text_zero, show_shadow, mode, timezone, hasTimePassed);
			}, 1000);
		}
	}

	return countdownInit;
});
