(function()
{
	var moduleName = 'cla.core';
	try {
		module = angular.module(moduleName);
	} catch(err) {
		// named module does not exist, so create one
		module = angular.module(moduleName, []);
	}

	angular.module(moduleName)
	.directive('claSugrePicker', ClaSugrePicker);

    ClaSugrePicker.$inject = ['$timeout'];
	function ClaSugrePicker($timeout)
	{
		return {
			restrict: 'E',
			require: '^ngModel',
			templateUrl: '/intranet/discuss/html/directives/sugre_picker.html',
			scope: {
				ngModel: '='
			},
			link: function(scope, iElement, iAttrs, ctrl)
			{
				scope.id = iAttrs.selectId + '-inner';
				scope.user_name = '';//iAttrs.userName;
				scope.allow_unset = iAttrs.allowUnset == 1;
				scope.hide_browse = iAttrs.hideBrowse == 1;

				scope.initSelect2 = function(id, text, allow_unset)
				{
					var select = $('#' + id);
					// Select2 needs a blank entry to go to when no user is selected. It should create this by itself but sometimes doesn't
					select.append($('<option>').attr('selected', 'selected'));

					// Add an entry for the current user if needed
					if (scope.ngModel.assigned_value !== null)
						select.append($('<option selected value="' + scope.ngModel.assigned_value + '">' + scope.ngModel.assigned_str + '</option>'));
					select.on('change', function(){
						var $el = angular.element(this);
						var sugre_id = $el.val();
						var name = sugre_id === '' ? '' : $el.find('option[value='+sugre_id+']').text();
						scope.change(sugre_id, name);
					});

					window.UserPicker_InitSelect2SUGRE(id, '', text, allow_unset);
				};
				// Angular won't have populated the control/browse ids yet so wait until the current event is finished
				$timeout(function(id, text, allow_unset){
				    scope.initSelect2(id, text, allow_unset)
                }, 0, false, scope.id, lmsg('discuss.tasks.sugre_picker_placeholder'), scope.allow_unset);

				$('#' + scope.id).append($('<option>').attr('value', scope.$modelValue).attr('selected', 'selected').text(scope.user_name));

				scope.change = function(sugre_id, name)
				{
					$timeout(function(select, id, name)
					{
						ctrl.$setViewValue({
							assigned_value: id,
							assigned_str: name
						});
						ctrl.$render();
					}, 0, false, scope.id, sugre_id, name);
				};

				scope.browse = function(event)
				{
					event.preventDefault();
					var recwnd = window.open('/intranet/common/user_picker_popup.php?input_dom_id='+scope.id+'','user_picker_wnd','width=800,height=450,scrollbars=yes,resizable=yes,hotkeys=no,maximize=no');
					recwnd.focus();
				};

				scope.reset = function(user_name)
				{
					var select = $('#' + scope.id);
					select.find('option').remove();

					scope.user_name = user_name;
					scope.initSelect2(scope.id, "Select a user", true);
				};

				ctrl.$viewChangeListeners.push(function() {
					scope.$eval(iAttrs.ngChange);
				});
			}
		};
	};
}());
