(function()
{
	var moduleName = 'cla.discuss';

	angular
		.module(moduleName)
		.controller('viewAllController', ['discuss.datasource', '$state', 'breadcrumb.service', allController]);

	function allController(dataSrc, $state, breadcrumbService)
	{
		var ctrl = this;
		ctrl.dataSrc = dataSrc;
		ctrl.common = ctrl.dataSrc.getCommonData();
		ctrl.showMoreDetails = false;

		// Hide all tooltips
		angular.element('.tooltip.fade').remove();

		breadcrumbService.setCrumbs(
		[
			{
				'url': '/intranet/discuss',
				'name': lmsg('discuss.breadcrumb.discuss')
			},
			{
				'url': '/intranet/discuss/discussion.php?id=' + ctrl.common.id,
				'name': ctrl.common.title
			}
		]);

		ctrl.toggleMoreDetails = function($event)
		{
			$event.preventDefault();
			ctrl.showMoreDetails = !ctrl.showMoreDetails;

			if (ctrl.showMoreDetails)
				angular.element('#show_more_details').tooltip('hide');
			else
				angular.element('#hide_more_details').tooltip('hide');

			angular.element('#collapseMoreInfo').slideToggle(500);
		};
	}
}());