(function()
{
	var moduleName = 'cla.discuss';

	angular.module(moduleName)
	.controller('categoriesController', ['categoriesService', 'tilesService', categories_controller]);

	function categories_controller(categoriesService, tilesService)
	{
		var ctrl = this;
		ctrl.categoriesService = categoriesService;
		ctrl.tilesService = tilesService;

		ctrl.categories = ctrl.categoriesService.getCategoryData();

		ctrl.current = 0;

		// data callback for data updates
		ctrl.dataCallback = function (category_counts)
		{
			for (var i in ctrl.categories)
			{
				if (category_counts[ctrl.categories[i].id] === undefined) {
					category_counts[ctrl.categories[i].id] = {count: 0};
				}

				var count = category_counts[ctrl.categories[i].id].count;
				ctrl.categories[i].count = count === undefined ? 0 : count;
			}
		};
		ctrl.categoriesService.setDataCallback(ctrl.dataCallback);

		ctrl.setCategory = function($event, cat)
		{
			$event.preventDefault();

			ctrl.current = cat;
			ctrl.tilesService.setCategory(ctrl.current);
		};
	}
}());