(function()
{
	var moduleName = 'cla.discuss';

	angular
		.module(moduleName)
		.controller('eventsListController', ['eventsService', '$state', 'breadcrumb.service', eventsListController])
		.controller('eventsPendingController', ['eventsService', eventsPendingController])
		.controller('eventsAddController', ['eventsService', '$state', 'growl.service', 'breadcrumb.service', eventsAddController])
		.controller('eventsEditController', ['eventsService', '$state', 'growl.service', 'breadcrumb.service', eventsEditController])
		.controller('eventsDetailController', ['eventsService', '$state', 'breadcrumb.service', eventsDetailController]);

	function eventsListController(dataSrc, $state, breadcrumbService)
	{
		var ctrl = this;
		ctrl.dataSrc = dataSrc;
		ctrl.common = ctrl.dataSrc.getCommonData();

		// Hide all tooltips
		angular.element('.tooltip.fade').remove();

		breadcrumbService.setCrumbs(
		[
			{
				'url': '/intranet/discuss',
				'name': lmsg('discuss.breadcrumb.discuss')
			},
			{
				'url': '#/all',
				'name': ctrl.common.title
			},
			{
				'url': '#/events',
				'name': lmsg('discuss.breadcrumb.events')
			}
		]);

		ctrl.events = ctrl.dataSrc.getEventData();
		ctrl.dataSrc.loadEventData()
		.then(function()
		{
			ctrl.events = ctrl.dataSrc.getEventData();
		});

		ctrl.editEvent = function($event, event_id)
		{
			$event.preventDefault();
			$state.go('events_edit', {event_id: event_id});
		};

		ctrl.deleteEvent = function($event, event_id)
		{
			$event.preventDefault();

			angular.element('#event_delete-' + event_id).tooltip('hide');
			
			if (!confirm(lmsg("discuss.event.confirm_delete")))
				return;

			ctrl.dataSrc.deleteEvent(event_id);
			$state.go('events');
		};
	}

	function eventsPendingController(dataSrc)
	{
		var ctrl = this;
		ctrl.dataSrc = dataSrc;
		ctrl.common = ctrl.dataSrc.getCommonData();

		// Hide all tooltips
		angular.element('.tooltip.fade').remove();

		ctrl.events = ctrl.dataSrc.getPendingEventData();
		ctrl.dataSrc.loadPendingEventData()
		.then(function()
		{
			ctrl.events = ctrl.dataSrc.getPendingEventData();
		});
	}

	function eventsAddController(dataSrc, $state, growlService, breadcrumbService)
	{
		var ctrl = this;
		ctrl.dataSrc = dataSrc;
		ctrl.common = ctrl.dataSrc.getCommonData();
		ctrl.growl = growlService;

		// Hide all tooltips
		angular.element('.tooltip.fade').remove();

		breadcrumbService.setCrumbs(
		[
			{
				'url': '/intranet/discuss',
				'name': lmsg('discuss.breadcrumb.discuss')
			},
			{
				'url': '#/all',
				'name': ctrl.common.title
			},
			{
				'url': '#/events',
				'name': lmsg('discuss.breadcrumb.events')
			},
			{
				'url': '#/events/add',
				'name': lmsg('discuss.breadcrumb.add_event')
			}
		]);

		ctrl.tempEvent =
		{
			title: '',
			date_start: '',
			date_end: '',
			date_start_short: '',
			date_end_short: '',
			time_start: 'xx:xx',
			time_end: 'xx:xx',
			discuss_id: ctrl.common.id
		};

		ctrl.addEvent = function($event)
		{
			$event.preventDefault();

			// A crude check for empty titles
			if (ctrl.tempEvent.title.length < 1)
			{
				ctrl.growl.showError(lmsg('discuss.event.no_title'));
				return;
			}

			// Must have at least one date
			if ((ctrl.tempEvent.date_start == '') &&
				(ctrl.tempEvent.date_end == ''))
			{
				ctrl.growl.showError(lmsg('discuss.event.no_dates'));
				return;
			}

			ctrl.dataSrc.addEvent(ctrl.tempEvent)
			.then(function()
			{
				$state.go('events');
			});
		};
	}

	function eventsEditController(dataSrc, $state, growlService, breadcrumbService)
	{
		var ctrl = this;
		ctrl.dataSrc = dataSrc;
		ctrl.common = ctrl.dataSrc.getCommonData();
		ctrl.growl = growlService;

		// Hide all tooltips
		angular.element('.tooltip.fade').remove();

		ctrl.tempEvent =
		{
			title: '',
			date_start: '',
			date_end: '',
			date_start_short: '',
			date_end_short: '',
			time_start: 'xx:xx',
			time_end: 'xx:xx',
			discuss_id: ctrl.common.id
		};

		ctrl.dataSrc.loadEventData();
		var event = ctrl.dataSrc.getSingleEventData($state.params.event_id);
		if (event === null)
		{
			$state.go('events');
			return;
		}

		breadcrumbService.setCrumbs(
		[
			{
				'url': '/intranet/discuss',
				'name': lmsg('discuss.breadcrumb.discuss')
			},
			{
				'url': '#/all',
				'name': ctrl.common.title
			},
			{
				'url': '#/events',
				'name': lmsg('discuss.breadcrumb.events')
			},
			{
				'url': '#/events/edit/' + ctrl.common.id,
				'name': lmsg('discuss.breadcrumb.edit_event') + ': ' + event.title
			}
		]);

		ctrl.tempEvent.id = event.id;
		ctrl.tempEvent.discuss_id = event.discuss_id;
		ctrl.tempEvent.title = event.title;
		ctrl.tempEvent.date_start = event.date_start;
		ctrl.tempEvent.date_end = event.date_end;
		ctrl.tempEvent.date_start_short = event.date_start_short;
		ctrl.tempEvent.date_end_short = event.date_end_short;
		ctrl.tempEvent.time_start = event.time_start;
		ctrl.tempEvent.time_end = event.time_end;

		ctrl.editEvent = function($event)
		{
			$event.preventDefault();

			// A crude check for empty titles
			if (ctrl.tempEvent.title.length < 1)
			{
				ctrl.growl.showError(lmsg('discuss.event.no_title'));
				return;
			}

			ctrl.dataSrc.editEvent(ctrl.tempEvent)
			.then(function()
			{
				$state.go('events');
			});
		};
	}

	/*
	 	EVENT DETAILS CONTROLLER
	 */
	function eventsDetailController(dataSrc, $state, breadcrumbService)
	{
		var ctrl = this;
		ctrl.dataSrc = dataSrc;
		ctrl.common = ctrl.dataSrc.getCommonData();

		// Hide all tooltips
		angular.element('.tooltip.fade').remove();

		ctrl.event =
		{
			id: $state.params.event_id,
			title: '',
			date_start: '',
			date_end: '',
			time_start: '',
			time_end: '',
			can_manage: false,
			discuss_id: ctrl.common.id,
			aggregation: 'discuss_event'
		};

		breadcrumbService.setCrumbs(
			[
				{
					'url': '/intranet/discuss',
					'name': lmsg('discuss.breadcrumb.discuss')
				},
				{
					'url': '#/all',
					'name': ctrl.common.title
				},
				{
					'url': '#/events',
					'name': lmsg('discuss.breadcrumb.events')
				},
				{
					'url': '#/events/' + ctrl.event.id,
					'name': ctrl.event.title
				}
			]);

		ctrl.dataSrc.loadEventData()
		.then(function()
		{
			var event = ctrl.dataSrc.getSingleEventData($state.params.event_id);

			if (event === null)
				$state.go('events');

			ctrl.event =
			{
				id: event.id,
				title: event.title,
				date_start: event.date_start,
				date_end: event.date_end,
				time_start: event.time_start,
				time_end: event.time_end,
				can_manage: event.can_manage,
				discuss_id: ctrl.common.id,
				aggregation: 'discuss_event'
			};

			breadcrumbService.setCrumbs(
			[
				{
					'url': '/intranet/discuss',
					'name': lmsg('discuss.breadcrumb.discuss')
				},
				{
					'url': '#/all',
					'name': ctrl.common.title
				},
				{
					'url': '#/events',
					'name': lmsg('discuss.breadcrumb.events')
				},
				{
					'url': '#/events/' + ctrl.event.id,
					'name': ctrl.event.title
				}
			]);
		});

		ctrl.editEvent = function($event, event_id)
		{
			angular.element('#event-edit-' + event_id).tooltip('hide');
		};

		ctrl.deleteEvent = function($event, event_id)
		{
			$event.preventDefault();

			if (!confirm(lmsg("discuss.event.confirm_delete")))
				return;

			angular.element('#event-delete-' + event_id).tooltip('hide');
			ctrl.dataSrc.deleteEvent(event_id);
			$state.go('events');
		};
	}
}());