(function()
{
	var moduleName = 'cla.discuss';

	angular
		.module(moduleName)
		.controller('notesListController', ['discuss.datasource', 'breadcrumb.service', notesListController])
		.controller('notesAddController', ['discuss.datasource', '$state', 'growl.service', 'breadcrumb.service', notesAddController])
		.controller('notesEditController', ['discuss.datasource', '$state', 'growl.service', 'breadcrumb.service', notesEditController])
		.controller('notesDetailController', ['discuss.datasource', '$state', 'breadcrumb.service', notesDetailController]);

	/*
		NOTE LIST CONTROLLER
	 */
	function notesListController(dataSrc, breadcrumbService)
	{
		var ctrl = this;
		ctrl.dataSrc = dataSrc;
		ctrl.common = ctrl.dataSrc.getCommonData();

		// Hide all tooltips
		angular.element('.tooltip.fade').remove();

		breadcrumbService.setCrumbs(
		[
			{
				'url': '/intranet/discuss',
				'name': lmsg('discuss.breadcrumb.discuss')
			},
			{
				'url': '#/all',
				'name': ctrl.common.title
			},
			{
				'url': '#/notes',
				'name': lmsg('discuss.breadcrumb.notes')
			}
		]);

		ctrl.notes = ctrl.dataSrc.getNoteData();

		ctrl.loadData = function()
		{
			ctrl.dataSrc.loadNoteData()
			.then(function()
			{
				ctrl.notes = ctrl.dataSrc.getNoteData();
			});
		};
		ctrl.loadData();

		ctrl.editNote = function($event, note_id)
		{
			angular.element('#note-edit-' + note_id).tooltip('hide');
		};

		ctrl.deleteNote = function($event, note_id)
		{
			$event.preventDefault();

			if (!confirm(lmsg("discuss.note.confirm_delete")))
				return;

			angular.element('#note-delete-' + note_id).tooltip('hide');
			ctrl.dataSrc.deleteNote(note_id);
			ctrl.notes = ctrl.dataSrc.getNoteData();
		};
	}

	/*
	 	NOTE ADD CONTROLLER
	 */
	function notesAddController(dataSrc, $state, growl, breadcrumbService)
	{
		var ctrl = this;
		ctrl.dataSrc = dataSrc;
		ctrl.growl = growl;
		ctrl.common = ctrl.dataSrc.getCommonData();

		// Hide all tooltips
		angular.element('.tooltip.fade').remove();

		breadcrumbService.setCrumbs(
		[
			{
				'url': '/intranet/discuss',
				'name': lmsg('discuss.breadcrumb.discuss')
			},
			{
				'url': '#/all',
				'name': ctrl.common.title
			},
			{
				'url': '#/notes',
				'name': lmsg('discuss.breadcrumb.notes')
			},
			{
				'url': '#/notes/add',
				'name': lmsg('discuss.breadcrumb.add_note')
			}
		]);

		ctrl.tempNote =
		{
			title: '',
			note: '',
			id: 0
		};

		ctrl.addNote = function($event)
		{
			$event.preventDefault();

			// A crude check for empty titles
			if (ctrl.tempNote.title.length < 1)
			{
				ctrl.growl.showError(lmsg('discuss.note.no_title'));
				return;
			}

			ctrl.dataSrc.addNote(ctrl.tempNote)
			.then(function()
			{
				$state.go('notes');
			});
		};
	}

	/*
	 	NOTE EDIT CONTROLLER
	 */
	function notesEditController(dataSrc, $state, growl, breadcrumbService)
	{
		var ctrl = this;
		ctrl.dataSrc = dataSrc;
		ctrl.growl = growl;
		ctrl.common = ctrl.dataSrc.getCommonData();

		// Hide all tooltips
		angular.element('.tooltip.fade').remove();

		ctrl.tempNote =
		{
			title: '',
			note: '',
			id: 0
		};

		ctrl.dataSrc.loadNoteData();
		var note = ctrl.dataSrc.getSingleNoteData($state.params.note_id);
		if (note === null)
		{
			$state.go('notes');
			return;
		}

		breadcrumbService.setCrumbs(
		[
			{
				'url': '/intranet/discuss',
				'name': lmsg('discuss.breadcrumb.discuss')
			},
			{
				'url': '#/all',
				'name': ctrl.common.title
			},
			{
				'url': '#/notes',
				'name': lmsg('discuss.breadcrumb.notes')
			},
			{
				'url': '#/notes/edit/' + note.id,
				'name': lmsg('discuss.breadcrumb.edit_note') + ': ' + note.title
			}
		]);

		ctrl.tempNote.title = note.title;
		ctrl.tempNote.note = note.text;
		ctrl.tempNote.id = note.id;

		ctrl.editNote = function($event)
		{
			$event.preventDefault();

			// A crude check for empty titles
			if (ctrl.tempNote.title.length < 1)
			{
				ctrl.growl.showError(lmsg('discuss.note.no_title'));
				return;
			}

			ctrl.dataSrc.editNote(ctrl.tempNote)
			.then(function()
			{
				$state.go('notes');
			});
		};
	}

	/*
	 	NOTE DETAILS CONTROLLER
	 */
	function notesDetailController(dataSrc, $state, breadcrumbService)
	{
		var ctrl = this;
		ctrl.dataSrc = dataSrc;
		ctrl.common = ctrl.dataSrc.getCommonData();

		// Hide all tooltips
		angular.element('.tooltip.fade').remove();

		ctrl.dataSrc.loadNoteData();
		var note = ctrl.dataSrc.getSingleNoteData($state.params.note_id);
		if (ctrl.note === null)
			$state.go('notes');

		ctrl.note =
		{
			title: note.title,
			note: note.text,
			note_display: note.text_display,
			id: note.id,
			aggregation: 'discuss_note',
			can_manage: note.can_manage
		};

		breadcrumbService.setCrumbs(
		[
			{
				'url': '/intranet/discuss',
				'name': lmsg('discuss.breadcrumb.discuss')
			},
			{
				'url': '#/all',
				'name': ctrl.common.title
			},
			{
				'url': '#/notes',
				'name': lmsg('discuss.breadcrumb.notes')
			},
			{
				'url': '#/notes/' + note.id,
				'name': note.title
			}
		]);

		ctrl.editNote = function($event, note_id)
		{
			angular.element('#note-edit-' + note_id).tooltip('hide');
		};

		ctrl.deleteNote = function($event, note_id)
		{
			$event.preventDefault();

			if (!confirm(lmsg("discuss.note.confirm_delete")))
				return;

			angular.element('#note-delete-' + note_id).tooltip('hide');
			ctrl.dataSrc.deleteNote(note_id);
			$state.go('notes');
		};
	}
})();