(function()
{
	var moduleName = 'cla.discuss';

	angular.module(moduleName)
	.controller('tagController', ['tilesService', tag_controller]);

	function tag_controller(service)
	{
		var ctrl = this;
		ctrl.service = service;

		ctrl.tag = '';

		angular.element('#uni-tags').on('click', 'a', function(event)
		{
			event.preventDefault();
			var tag = angular.element(this).text();
			ctrl.toggleTag(tag);
			angular.element(this).toggleClass('active');
		});

		ctrl.toggleTag = function(tag)
		{
			if (ctrl.tag === tag)
				ctrl.tag = '';
			else
				ctrl.tag = tag;

			ctrl.service.setTag(ctrl.tag);

			if (tag === ctrl.tag)
			{
				angular.element('#uni-tags a').removeClass('active');
				return true;
			}

			return false;
		}
	}
}());