/**
 *
 * Note.
 * Needs extending to take language and buttons as parameters before being suitable for core.
 *
 */

(function()
{
	var moduleName = 'cla.core';
	try {
		module = angular.module(moduleName);
	} catch(err) {
		// named module does not exist, so create one
		module = angular.module(moduleName, []);
	}

	angular.module(moduleName)
	.directive('claBbcode', bbcode);

	function bbcode() {
		var directive = this;

		directive.initWYSIWYGEditor_BB = function(area_id, buttons, language)
		{
			var wbb_opt = {
				lang: language,
				autoresize: false,
				bodyclass: "wysiwyg_editor_textarea",
				buttons: buttons,
				allButtons: {
					mailto: {
						title: 'Email address',
						buttonText: 'Email',
						modal: {
							title: 'Insert email address',
							width: '600px',
							tabs: [
								{
									input: [
										{param: "SELTEXT",title:"Display text"},
										{param: "EMAIL",title:"Email address",validation: '(.)@(.)'}
									]
								}
							],
							onLoad: function() {},
							onSubmit: function() {}
						},
						transform: {
							'<a href="mailto:{EMAIL}">{SELTEXT}</a>':'[email={EMAIL}]{SELTEXT}[/email]'
						}
					},
					link_anything : {
						title: CURLANG.link,
						buttonHTML: '<span class="fonticon ve-tlb-link1">\uE007</span>',
						hotkey: 'ctrl+shift+2',
						modal: {
							title: CURLANG.modal_link_title,
							width: "500px",
							tabs: [
								{
									input: [
										{param: "SELTEXT",title:CURLANG.modal_link_text, type: "div"},
										{param: "URL",title:CURLANG.modal_link_url,validation: '^http(s)?://'}
									]
								}
							],
							onLoad: function() {
								$("input[name=URL]").prop('placeholder', "http://");
							}
						},
						transform : {
							'<a href="{URL}">{SELTEXT}</a>':'[url={URL}]{SELTEXT}[/url]',
							'<a href="{URL}">{URL}</a>':"[url]{URL}[/url]"
						}
					}
				}
			};

			if (directive.minheight)
				wbb_opt.minheight = directive.minheight;

			setTimeout(function()
			{
				angular.element('#' + area_id).wysibb(wbb_opt);

				var textarea_width = angular.element('#' + area_id).width();

				// Workaround for bug in jQuery/Chrome/webkit browsers where a hidden element can return a .width() as a percentage instead of pixels
				// See http://stackoverflow.com/a/6405917 and the fiddle at http://jsfiddle.net/leeives/ujE6s/ for an example
				// The workaround linked below using $(window).load(...) only works for visible elements so no use here
				// Now this will skip applying the Wysibb width if the textarea is exactly 100 and hidden.
				if ((textarea_width == '100') &&
					(!angular.element('#' + area_id).is(':visible')))
				{
					return;
				}
				angular.element('.wysibb').width(textarea_width);
			},0);
		};

		directive.linkFunc = function(scope, element, iAttrs, ctrl)
		{
			scope.id = iAttrs.id;
			scope.ctrl = ctrl;
			scope.buttons = 'removeFormat,bold,italic,underline,strike,sub,sup,email,link_anything';
			scope.rows = iAttrs.rows;
			scope.cols = iAttrs.cols;
			scope.language = wysibb_language;
			var changeFunc = iAttrs.ngChange;

			wbbdebug=false;

			directive.initWYSIWYGEditor_BB(scope.id + '-inner', scope.buttons, scope.language);

			// Keep model in sync
			element.on('click', '.wysibb-toolbar', function(){
				angular.element('#' + scope.id + '-inner').sync();
				scope.ngModel = angular.element('#' + scope.id + '-inner').bbcode();
				scope.$apply();
			});
			element.on('keyup', '.wysibb-text-editor', function(){
				angular.element('#' + scope.id + '-inner').sync();
				scope.ngModel = angular.element('#' + scope.id + '-inner').bbcode();
				scope.$apply();
			});

			ctrl.$viewChangeListeners.push(function() {
				scope.$eval(changeFunc);
			});
		};

		return {
			restrict: 'E',
			require: '^ngModel',
			templateUrl: '/intranet/discuss/html/directives/bbcode.html',
			scope: {
				ngModel: '='
			},
			link: directive.linkFunc
		};
	}
}());