(function()
{
	var moduleName = 'cla.core';
	try {
		module = angular.module(moduleName);
	} catch(err) {
		// named module does not exist, so create one
		module = angular.module(moduleName, []);
	}

	angular.module(moduleName)
	.directive('claDatePicker', datePicker);

	datePicker.$inject = ['$timeout'];

	function datePicker($timeout) {
		return {
			restrict: 'E',
			require: '^ngModel',
			templateUrl: '/intranet/discuss/html/directives/date_picker.html',
			scope: {
				ngModel: '='
			},
			link: function(scope, iElement, iAttrs, ctrl)
			{
				scope.id = iAttrs.id;
				scope.name = iAttrs.name;
				scope.ctrl = ctrl;

				ctrl.$viewChangeListeners.push(function() {
					scope.$eval(iAttrs.ngChange);
				});

				$timeout(function()
				{
					angular.element('#' + scope.id + '-inner')
						.datetimepicker(
							{
								format: cla_locale.date_format
							})
						.on('dp.change', function (e)
						{
							angular.element(this).trigger('change');
						});
				}, 0);
			}
		};
	}
}());