(function()
{
	var moduleName = 'cla.discuss';

	angular.module(moduleName)
	.service('adminService', ['$http', 'growl.service', adminService]);

	function adminService($http, growl)
	{
		var service = this;

		service.growl = growl;
		service.is_archived = discuss_data.is_archived;

		service.toggleArchive = function(id)
		{
			var promise = $http.put('/intranet/rest/discuss/archive/' + id)
			.then(function()
			{
				service.is_archived = !service.is_archived;
			}, function(result)
			{
				service.growl.showError(result.data);
			});

			return promise;
		};

		service.delete = function(id)
		{
			var promise = $http.post('/intranet/rest/discuss/delete/' + id)
			.then(null, function(result)
			{
				service.growl.showError(result.data);
			});

			return promise;
		};
	}
}());
