(function()
{
	var moduleName = 'cla.discuss';

	angular.module(moduleName)
	.service('discuss.data.infopanel', ['$timeout', '$http', function($timeout, $http)
	{
		var service = this;

		// How often to reload the nav data (in ms)
		service.RELOAD_TIMEOUT = 20000;

		service.pages = discuss_data.infoPanelBootstrap;
		service.id = discuss_data.id;
		service.callback = null;

		service.getPages = function()
		{
			return service.pages;
		};

		service.setCallback = function(callback)
		{
			service.callback = callback;
		};

		service.modifyData = function(page, count)
		{
			for (var i = 0; i < service.pages.length; i++)
			{
				if (service.pages[i].idx === page)
					service.pages[i].count = parseInt(service.pages[i].count) + count;
			}
		};

		// Regular AJAX call to update item counts on the nav menu
		service.getLatestData = function()
		{
			$http.get('/intranet/rest/discuss/status/' + service.id)
				.then(function(result)
				{
					if (result.status === 200)
					{
						service.pages = result.data;
						if (service.callback !== null)
						{
							// Tell the view directive this has changed
							service.callback(service.pages);
						}
					}
				});
			// Wait until and try again
			$timeout(service.getLatestData, service.RELOAD_TIMEOUT);
		};

		// Start the initial wait to update
		$timeout(service.getLatestData, service.RELOAD_TIMEOUT);
	}]);
}());
