var moduleName = 'cla.discuss';
angular.module(moduleName)
.config(routes);

routes.$inject = ['$stateProvider', '$urlRouterProvider', '$locationProvider'];
function routes($stateProvider, $urlRouterProvider, $locationProvider)
{
    $locationProvider.hashPrefix('');

	$stateProvider
	.state('plain', {
		url: "",
		views: {
			"body_view": { templateUrl: "/intranet/discuss/html/views/all.html", controller: "viewAllController as ctrl" }
		}
	})
	.state('all', {
		url: "/all",
		views: {
			"body_view": { templateUrl: "/intranet/discuss/html/views/all.html", controller: "viewAllController as ctrl" }
		}
	})
	.state('events', {
		url: "/events",
		views: {
			"body_view": { templateUrl: "/intranet/discuss/html/views/events_list.html", controller: "eventsListController as ctrl" }
		}
	})
	.state('events_add', {
		url: "/events/add",
		views: {
			"body_view": { templateUrl: "/intranet/discuss/html/views/events_add.html", controller: "eventsAddController as ctrl" }
		}
	})
	.state('events_edit', {
		url: "/events/edit/:event_id",
		views: {
			"body_view": { templateUrl: "/intranet/discuss/html/views/events_edit.html", controller: "eventsEditController as ctrl" }
		}
	})
	.state('events_detail', {
		url: "/events/:event_id",
		views: {
			"body_view": { templateUrl: "/intranet/discuss/html/views/events_detail.html", controller: "eventsDetailController as ctrl" }
		}
	})
	.state('tasks', {
		url: "/tasks",
		views: {
			"body_view": { templateUrl: "/intranet/discuss/html/views/task_list.html", controller: "tasksListController as ctrl" }
		}
	})
	.state('tasks_detail', {
		url: "/tasks/:task_id",
		views: {
			"body_view": { templateUrl: "/intranet/discuss/html/views/task_detail.html", controller: "tasksDetailController as ctrl" }
		}
	})
	.state('files', {
		url: "/files",
		views: {
			"body_view": { templateUrl: "/intranet/discuss/html/views/files_list.html", controller: "filesListController as ctrl" }
		}
	})
	.state('links', {
		url: "/links",
		views: {
			"body_view": { templateUrl: "/intranet/discuss/html/views/links_list.html", controller: "linksListController as ctrl" }
		}
	})
	.state('notes', {
		url: "/notes",
		views: {
			"body_view": { templateUrl: "/intranet/discuss/html/views/notes_list.html", controller: "notesListController as ctrl" }
		}
	})
	.state('notes_add', {
		url: "/notes/add",
		views: {
			"body_view": { templateUrl: "/intranet/discuss/html/views/notes_add.html", controller: "notesAddController as ctrl" }
		}
	})
	.state('notes_edit', {
		url: "/notes/edit/:note_id",
		views: {
			"body_view": { templateUrl: "/intranet/discuss/html/views/notes_edit.html", controller: "notesEditController as ctrl" }
		}
	})
	.state('notes_detail', {
		url: "/notes/:note_id",
		views: {
			"body_view": { templateUrl: "/intranet/discuss/html/views/notes_detail.html", controller: "notesDetailController as ctrl" }
		}
	});
}
