(function()
{
	var moduleName = 'cla.discuss';

	angular
		.module(moduleName)
		.controller('linksListController', ['discuss.datasource', 'breadcrumb.service', linksListController]);

	/*
	 	LINK LIST CONTROLLER
	 */
	function linksListController(dataSrc, breadcrumbService)
	{
		var ctrl = this;
		ctrl.dataSrc = dataSrc;
		ctrl.common = ctrl.dataSrc.getCommonData();

		// Hide all tooltips
		angular.element('.tooltip.fade').remove();

		breadcrumbService.setCrumbs(
		[
			{
				'url': '/intranet/discuss',
				'name': lmsg('discuss.breadcrumb.discuss')
			},
			{
				'url': '#/all',
				'name': ctrl.common.title
			},
			{
				'url': '#/links',
				'name': lmsg('discuss.breadcrumb.links')
			}
		]);

		ctrl.links = ctrl.dataSrc.getLinkData();
		ctrl.dataSrc.loadLinkData()
		.then(function()
		{
			ctrl.links = ctrl.dataSrc.getLinkData();
		});
	}
}());