<?php

/**
 * BT-5829
 * 
 * This migration identifies notes where 'created_by' and 'created_at' are NULL.
 * It populates these fields by using the `modified_by` and `modified_date` values.
 */

use Claromentis\Core\DAL;

/** @var \Claromentis\Setup\SetupFacade $migrations */
$logger = $migrations->getLogger();

$logger->notice("Starting migration for BT-5829");

$database = $migrations->GetDb();

try {
    $database->DoTransaction(function (DAL\Interfaces\DbInterface $database) use ($logger) {
        
        [$rowCount] = $database->query_row("SELECT COUNT(1) FROM discuss_note
            WHERE created_by IS NULL 
            AND created_date IS NULL
        ");

        if (!$rowCount) {
            $logger->notice('No records found for discuss notes with empty created_by/created_date fields. Skipping.');
            return;
        }

        $logger->notice("Found $rowCount records to update. Proceeding to populate created_by/created_date by using modified_by/modified_date fields.");

        $database->query("UPDATE discuss_note SET created_by = modified_by, created_date = modified_date WHERE created_by IS NULL");

        $logger->notice("Successfully updated $rowCount records.");
    });
} catch (DAL\Exceptions\TransactionException $exception) {
    $logger->error("Migration BT-5829 failed");
    throw $exception;
}