<?php

use Claromentis\Core\Acl\PermOClass;
use Claromentis\Core\Services;
use Claromentis\Menu\Infobar\MenuItemApplication;
use Claromentis\Menu\Infobar\MenuItemRepository;

if (!defined('INSTALL_PROGRESS'))
	die("This file cannot be executed directly");

if (!isset($installer))
	throw new Exception("Install options are not defined");

/** @var $installer Claromentis\Setup\SetupFacade */
$admin_panel = $installer->GetAdminPanelCreator();
$admin_panel->Enable('discuss');

$plugins = $installer->GetPluginsRepository();
$plugins->Add('discuss', '\Claromentis\Discuss\DiscussPlugin', ['task']);

$menu = Services::I()->{MenuItemRepository::class};
$menu->save(new MenuItemApplication('discuss', 'Discuss', '/discuss/'));

$db = $installer->GetDb();
$db->query(new \Claromentis\Core\DAL\QueryInsert('discuss_category', array(
		'str:name' => 'Default',
	    'int:created_by' => 1, // admin
	    'int:created_date' => Date::getNowTimestamp(),
	)));
$category_id = $db->insertId();

// Give everyone rights to create new discussions
$perms = new Permissions(83, 1); // 83 is PERM_CLASS_DISCUSS_ADMIN
$perms->Add(PERM_EDIT, PermOClass::ALL);
$perms->Save();

// Set default permissions to viewable for everyone
$perms = new Permissions(84, 1); // 84 is PERM_CLASS_DISCUSS_DEFAULT
$perms->Add(PERM_EDIT, PermOClass::ALL);
$perms->Save();

// Create a discussion
$discussion = new \Claromentis\Discuss\Discussion();
$discussion->SetTitle("Default Discussion")->SetDescription("Default");
$discussion->Save();
$discussion->SetCategoryIds([$category_id]);
$discussion->GetPerms()->Add(PERM_EDIT, PermOClass::ALL);
$discussion->GetPerms()->Save();


$data_dir = $installer->GetDataDir();
if (!is_dir("$data_dir/discuss"))
{
	mkdir("$data_dir/discuss", 0777);
	chmod("$data_dir/discuss", 0777);
}
if (!is_dir("$data_dir/discuss/covers"))
{
	mkdir("$data_dir/discuss/covers", 0777);
	chmod("$data_dir/discuss/covers", 0777);
}
