require(['jquery', 'cla_select2', 'jquery.validate', '../../lib/wysibb/jquery.wysibb.js'], function(jQuery)
{
	jQuery(document).ready(function() {

		// Category select
		jQuery("#categories").select2({
			placeholder: lmsg("discuss.edit.category_placeholder"),
			width: "300px",
			multiple: true,
			ajax: {
				url: "/intranet/rest/discuss/categories",
				dataType: "json",
				data: function(params) {
					params.page = params.page || 1;
					return {
						q: params.term,
						page_limit: 10,
						page: params.page
					};
				},
				processResults: function(data, params) {
					var more = (params.page * 10) < data.total;
					return {
						results: data.results,
						pagination: {
							more: more
						}
					};
				}
			},
			templateResult: function(cat) {
				return cat.text;
			},

			templateSelection: function(cat) {
				return cat.text;
			}
		});

        // check for validation
        jQuery('form[name=perms_dialog]').validate(
        {
            showErrors: function (errorMap, errorList) {
                // Do nothing, to suppress the default action of the field being annotated directly
            },
            invalidHandler: function (event, validator)
            {
                for (var i = 0; i < validator.errorList.length; i++)
                {
                    cla.showMessage($(validator.errorList[i].element).data('invalid-message'), '', true);
                }

                $('html, body').animate({
                    scrollTop: $(validator.errorList[0].element).offset().top - 120
                }, 200);
            },

        });
    });
});
