(function()
{
	var moduleName = 'cla.discuss';

	angular
		.module(moduleName)
		.controller('adminController', ['discuss.datasource', 'adminService', '$window', adminController]);

	function adminController(dataSrc, service, $window)
	{
		var ctrl = this;
		ctrl.service = service;
		ctrl.$window = $window;
		ctrl.common = dataSrc.getCommonData();
		ctrl.is_archived = ctrl.service.is_archived;

		ctrl.toggleArchive = function($event)
		{
			$event.preventDefault();

			var msg = 'discuss.detail.unarchive_popup_msg';
			if (ctrl.is_archived)
			{
				angular.element('#unarchive_link').tooltip('hide');
			} else
			{
				msg = 'discuss.detail.archive_popup_msg';
				angular.element('#archive_link').tooltip('hide');
			}

			msg = lmsg(msg);

			if (confirm(msg))
			{
				ctrl.service.toggleArchive(ctrl.common.id)
				.then(function()
				{
					ctrl.is_archived = ctrl.service.is_archived;

					// Reload the page so that the comments pick up changed permissions
                    location.reload(true);
				});
			}
		};

		ctrl.delete = function($event)
		{
			$event.preventDefault();

			if (confirm(lmsg('discuss.discussion.confirm_delete')))
			{
				ctrl.service.delete(ctrl.common.id)
				.then(function()
				{
					$window.location.href = '/discuss';
				});
			}
		};
	}
}());
