(function()
{
	angular
		.module('cla.discuss')

		.filter("sanitize", ['$sce', function($sce) {
			return function(htmlCode){
				return $sce.trustAsHtml(htmlCode);
			}
		}])

		.run(['$rootScope', '$state', function ($rootScope, $state)
		{
			// Allow routed states to redirect to another one without needing a controller and/or template
			$rootScope.$on('$stateChangeStart', function(evt, to, params) {
				if (to.redirectTo) {
					evt.preventDefault();
					$state.go(to.redirectTo, params)
				}
			});
		}]);
}());