(function()
{
	var moduleName = 'cla.discuss';

	angular
		.module(moduleName)
		.controller('filesListController', ['discuss.datasource', 'breadcrumb.service', filesListController]);

	function filesListController(dataSrc, breadcrumbService)
	{
		var ctrl = this;
		ctrl.dataSrc = dataSrc;
		ctrl.common = ctrl.dataSrc.getCommonData();

		// Hide all tooltips
		angular.element('.tooltip.fade').remove();

		breadcrumbService.setCrumbs(
		[
			{
				'url': '/intranet/discuss',
				'name': lmsg('discuss.breadcrumb.discuss')
			},
			{
				'url': '#/all',
				'name': ctrl.common.title
			},
			{
				'url': '#/files',
				'name': lmsg('discuss.breadcrumb.files')
			}
		]);

		ctrl.files = ctrl.dataSrc.getFileData();
		ctrl.dataSrc.loadFileData()
		.then(function()
		{
			ctrl.files = ctrl.dataSrc.getFileData();
			for (var i = 0; i < ctrl.files.length; i++)
			{
				// Type 2 (Attachment::TYPE_DOC) needs a different download link in the template
				ctrl.files[i].isInDocuments = ctrl.files[i].type == 2;
			}
		});
	}
}());