(function()
{
	var moduleName = 'cla.discuss';

	angular.module(moduleName)
	.directive('infopanelNavigation', infopanelNavigation);

	infopanelNavigation.$inject= ['$location', 'discuss.data.infopanel', 'discuss.datasource'];
	function infopanelNavigation($location, service, dataSrc)
	{
		var controller = function($scope)
		{
			var ctrl = this;

			ctrl.service = service;
			ctrl.dataSrc = dataSrc;

			ctrl.state = ctrl.service.getPages();
			ctrl.id = discuss_data.id;
			ctrl.current = $location.url();

			var receiveNewData = function(data)
			{
				ctrl.state = data;
			};
			ctrl.service.setCallback(receiveNewData);

			// When a nav link is clicked
			ctrl.navClicked = function(index)
			{
				ctrl.current = '/' + index;
			};

			// Monitor URL changing to keep the current state correct and an entry highlighted
			$scope.$on('$stateChangeSuccess', function(evt, to, params)
			{
				var loc = $location.url();
				loc = loc.split('/');
				if (loc.length === 1)
					ctrl.current = '/all';
				else
					ctrl.current = '/' + loc[1];
			});
		};
		controller.$inject = ['$scope'];

		return {
			restrict: 'E',
			templateUrl: '/intranet/discuss/html/directives/infopanel.html',
			scope: {},
			controllerAs: 'infopanel',
			bindToController: true,
			controller: controller
		};
	}
}());