(function()
{
	var moduleName = 'cla.discuss';

	angular
		.module(moduleName)
		.controller('tasksListController', ['tasksService', 'discuss.datasource', '$state', '$timeout', 'growl.service', 'breadcrumb.service', tasksListController])
		.controller('tasksDetailController', ['tasksService', 'discuss.datasource', '$state', 'growl.service', 'breadcrumb.service', tasksDetailController]);

	function tasksListController(service, dataSrc, $state, $timeout, growl, breadcrumbService)
	{
		var ctrl = this;
		ctrl.service = service;
		ctrl.dataSrc = dataSrc;
		ctrl.common = ctrl.dataSrc.getCommonData();
		ctrl.growl = growl;
		ctrl.isAdding = false;
		ctrl.addData = {};

		// Hide all tooltips
		angular.element('.tooltip.fade').remove();

		breadcrumbService.setCrumbs(
		[
			{
				'url': '/intranet/discuss',
				'name': lmsg('discuss.breadcrumb.discuss')
			},
			{
				'url': '#/all',
				'name': ctrl.common.title
			},
			{
				'url': '#/tasks',
				'name': lmsg('discuss.tab.tasks')
			}
		]);

		ctrl.resetAddData = function()
		{
			ctrl.addData =
			{
				aggregation: ctrl.common.aggregation,
				object_id: ctrl.common.id,
				title: '',
				assigned: 0,
				assigned_oclass: 1,
				completed: false,
				once_completed: false,
				due: '',
				priority: '6',
				repeat: '0',
				assigned_ngModel: {assigned_value: null, assigned_str: ''}
			};
		};
		ctrl.resetAddData();

		ctrl.tasks = ctrl.service.getTaskData();
		ctrl.service.loadTaskData()
		.then(function()
		{
			ctrl.tasks = ctrl.service.getTaskData();
		});

		ctrl.tasksUpdatedCallback = function()
		{
			ctrl.tasks = ctrl.service.getTaskData();
		};
		ctrl.service.setCallback(ctrl.tasksUpdatedCallback);

		ctrl.showAdd = function($event)
		{
			$event.preventDefault();

			ctrl.isAdding = true;
			ctrl.resetAddData();

			// Select2 must be called after the digest or the elements won't exist yet due to being in an ng-if
			$timeout(function()
			{
				angular.element('#addPriorityFlag').select2(
				{
					templateResult: function(data)
					{
						return $('<span class="' + data.text + '"></span>');
					},
					templateSelection: function(data)
					{
						return $('<span class="' + data.text + '"></span>');
					},
					minimumResultsForSearch: Infinity // Hide search box
				});
				angular.element('#addRepeatPeriod').select2(
				{
					minimumResultsForSearch: Infinity // Hide search box
				});
				angular.element('#new_task_due_date')
				.datetimepicker(
					{
						format: cla_locale.date_format
					})
				.on('dp.change', function (e)
				{
					angular.element(this).trigger('change');
				});

                // Scrolls task form into view on click
                const taskForm = document.getElementById('add-task-form');
                taskForm.scrollIntoView({behavior: "smooth"});
			}, 0);


		};

		ctrl.cancelAdd = function($event)
		{
			$event.preventDefault();

			ctrl.isAdding = false;
		};

		ctrl.add = function($event)
		{
			$event.preventDefault();

			if (ctrl.addData.title === '')
			{
				ctrl.growl.showError(lmsg('discuss.edit.missing_title_msg'));
				return;
			}

			ctrl.addData.assigned = ctrl.addData.assigned_ngModel.assigned_value;
			ctrl.service.save(ctrl.addData)
			.then(function(result)
			{
				ctrl.tasks.push(result.data);
				ctrl.service.adjustCount(1);
                ctrl.service.processTasks();
			});
			ctrl.isAdding = false;
		};

		ctrl.resetAddDate = function(event)
		{
			event.preventDefault();

			ctrl.addData.due = '';
		};

		ctrl.editTask = function($event, task_id)
		{
			$event.preventDefault();

			angular.element('#task-edit-' + task_id).tooltip('hide');
			for (var i = 0; i < ctrl.tasks.length; i++)
			{
				if (ctrl.tasks[i].id == task_id)
					ctrl.tasks[i].isEdit = true;
			}
		};

		ctrl.cancelEdit = function($event, task_id)
		{
			$event.preventDefault();

			for (var i = 0; i < ctrl.tasks.length; i++)
			{
				if (ctrl.tasks[i].id == task_id)
					ctrl.tasks[i].isEdit = false;
			}
		};

		ctrl.deleteTask = function($event, task_id)
		{
			$event.preventDefault();

			if (confirm(lmsg('discuss.task.confirm_delete')))
			{
				angular.element('#task-delete-' + task_id).tooltip('hide');
				ctrl.service.deleteTask(task_id);
				for (var i = 0; i < ctrl.tasks.length; i++)
				{
					if ((ctrl.tasks[i].id == task_id) &&
						(!ctrl.tasks[i].completed))
					{
						service.adjustCount(-1);
					}
				}
			}
		};

		ctrl.changeCompleted = function($event, task_id)
		{
            // We are about to send a new "get all tasks" request so cancel any previous one
            service.cancelAllTaskRequests();

			for (var loopIndex = 0; loopIndex < ctrl.tasks.length; loopIndex++)
			{
				if (ctrl.tasks[loopIndex].id == task_id)
				{
					// By the time the save promise is resolved `loopIndex` may have changed so make a copy now
					var foundIndex = loopIndex;

					ctrl.service.save(ctrl.tasks[foundIndex])
					.then(function()
					{
						if ((ctrl.tasks[foundIndex].completed) &&
						((ctrl.tasks[foundIndex].repeat == 0) || (ctrl.tasks[foundIndex].once_completed)))
						{
							ctrl.service.adjustCount(-1);
						} else if (!ctrl.tasks[foundIndex].completed)
						{
							ctrl.service.adjustCount(1)
						}

						ctrl.service.loadTaskData()
						.then(function()
						{
							ctrl.tasks = ctrl.service.getTaskData();
						});
					});
				}
			}
		};
	}

	function tasksDetailController(service, dataSrc, $state, growl, breadcrumbService)
	{
		var ctrl = this;
		ctrl.service = service;
		ctrl.dataSrc = dataSrc;
		ctrl.common = ctrl.dataSrc.getCommonData();
		ctrl.growl = growl;

		// Hide all tooltips
		angular.element('.tooltip.fade').remove();

		ctrl.service.loadTaskData();

		ctrl.prepareTask = function()
		{
			var task = ctrl.service.getSingleTaskData($state.params.task_id);
			if (task === null)
				$state.go('tasks');

			ctrl.task =
			{
				aggregation: 'task',
				isEdit: false
			};
			angular.element.extend(ctrl.task, task);

			breadcrumbService.setCrumbs(
			[
				{
					'url': '/intranet/discuss',
					'name': lmsg('discuss.breadcrumb.discuss')
				},
				{
					'url': '#/all',
					'name': ctrl.common.title
				},
				{
					'url': '#/tasks',
					'name': lmsg('discuss.tab.tasks')
				},
				{
					'url': '#/tasks/ctrl.task.id',
					'name': ctrl.task.title
				}
			]);
		};
		ctrl.prepareTask();
		ctrl.service.setCallback(ctrl.prepareTask);

		ctrl.editTask = function($event)
		{
			$event.preventDefault();

			angular.element('#task-edit').tooltip('hide');
			ctrl.task.isEdit = true;
		};

		ctrl.cancelEdit = function($event)
		{
			$event.preventDefault();

			ctrl.isEdit = false;
		};

		ctrl.deleteTask = function($event)
		{
			$event.preventDefault();

			if (confirm('[Are you sure]'))
			{
				angular.element('#task-delete').tooltip('hide');
				ctrl.service.deleteTask(ctrl.task.id);
				$state.go('tasks');
			}
		};

		ctrl.changeCompleted = function($event)
		{
			ctrl.service.save(ctrl.task)
			.then(function()
			{
				$state.go('tasks');
			});
		};
	}
}());
