(function()
{
	var moduleName = 'cla.discuss';

	angular.module(moduleName)
	.service('tasksService', ['$http', '$q', 'growl.service', 'discuss.datasource', 'discuss.data.infopanel', tasksService]);

	function tasksService($http, $q, growl, dataSrc, infoPanel)
	{
		var service = this;

		service.growl = growl;
		service.dataSrc = dataSrc;
		service.commonData = service.dataSrc.getCommonData();
		service.tasks = [];
		service.filters =
		{
			showCompleted: false,
			priority: 0,
			assigned: 0,
			dueDate: ''
		};

		service.callback = null;

        service.requestCancellers = [];

		service.loadTaskData = function()
		{
            // We are about to send a new "get all tasks" request so cancel any previous one
            service.cancelAllTaskRequests();

			// Use data provided by the server if there is any, then invalidate it
			if (tasks_data != null)
			{
				service.tasks = tasks_data.results;
				tasks_data = null;
				service.processTasks();
				return $q.when(null);
			}

            var params = {
                aggregation: service.commonData.aggregation,
                object_id: service.commonData.id
            };
			if (service.filters.showCompleted)
				params.completed = 1;

			if (parseInt(service.filters.priority) > 0)
				params.priority = service.filters.priority;

			if (service.filters.asigned != 0)
				params.assigned = service.filters.assigned;

			if (service.filters.dueDate != '')
				params.due = service.filters.dueDate;

            // `$q.defer()` creates a new promise
            var canceller = $q.defer();
            service.requestCancellers.push(canceller);

			return $http({
                method: 'get',
                url: '/intranet/rest/task/tasks',
                params:  params,
                timeout: canceller.promise       // `timeout` can be milliseconds or a promise that cancels it once resolved
            }).then(function(result)
			{
				if (result.status === 200)
				{
					service.tasks = result.data.results;
					service.processTasks();
				}
			}).catch(function (error) {
				if (error.xhrStatus === 'abort') {
					console.debug('Task data request cancelled');
					return;
				}

				console.error('Error loading task data', error);
			});
		};

		service.processTasks = function()
		{
			for (var i = 0; i < service.tasks.length; i++)
			{
				service.tasks[i].isEdit = false;
				service.tasks[i].aggregation = 'task';
			}
		};

		service.setCallback = function(callbackFunc)
		{
			service.callback = callbackFunc;
		};

		service.getTaskData = function()
		{
			return service.tasks;
		};

		service.getSingleTaskData = function($task_id)
		{
			var task = null;
			for (var i = 0; i < service.tasks.length; i++)
			{
				if (service.tasks[i].id == $task_id)
					task = service.tasks[i];
			}

			return task;
		};

		service.save = function(data)
		{
			// REST API needs "due" to be the short date format for PUT/POST
			// A copy is used to avoid the temporary change from being displayed until the REST call ends
			var dataCopy = angular.element.extend({}, data);
			if (dataCopy.due_short !== undefined)
				dataCopy.due = dataCopy.due_short;

			if (dataCopy.id)
				var promise = $http.put('/intranet/rest/task/task/' + dataCopy.id, dataCopy);
			else
				var promise = $http.post('/intranet/rest/task/task', dataCopy);
			promise.then(function(result)
			{
				for (var i = 0; i < service.tasks.length; i++)
				{
					if (service.tasks[i].id == dataCopy.id)
					{
						service.tasks[i] = result.data;
						service.processTasks();
						service.callback();
					}
				}
			}, function(result)
			{
				service.growl.showError(result);
			});
			return promise;
		};

		service.deleteTask = function(task_id)
		{
			var promise = $http.delete('/intranet/rest/task/task/' + task_id)
			.then(function()
			{
				var tasks = [];
				for (var i = 0; i < service.tasks.length; i++)
				{
					if (service.tasks[i].id != task_id)
						tasks.push(service.tasks[i]);
				}
				service.tasks = tasks;
				service.callback();
			}, function(result)
			{
				service.growl.showError(result);
			});

			return promise;
		};

		// Filters
		service.setFilterCompleted = function(showCompleted)
		{
			service.filters.showCompleted = showCompleted;

			service.loadTaskData()
			.then(function()
			{
				service.callback();
			});
		};

		service.setFilterPriority = function(priority)
		{
			service.filters.priority = priority;

			service.loadTaskData()
			.then(function()
			{
				service.callback();
			});
		};

		service.setFilterAssigned = function(assigned)
		{
			service.filters.assigned = assigned;
			service.loadTaskData()
			.then(function()
			{
				service.callback();
			});
		};

		service.setFilterDueDate = function(dueDate)
		{
			service.filters.dueDate = dueDate;
			service.loadTaskData()
			.then(function()
			{
				service.callback();
			});
		};

		service.adjustCount = function(changeAmount)
		{
			infoPanel.modifyData('tasks', changeAmount);
		};

        service.cancelAllTaskRequests = function()
        {
            for (var i = 0; i < service.requestCancellers.length; i++)
            {
                // If the promise isn't resolved yet, cancel it
                if (service.requestCancellers[i].promise.$$state.status === 0)
                    service.requestCancellers[i].resolve('Cancelled');
            }

            // Stop tracking them all
            service.requestCancellers.length = 0;
        };
	}
}());
