(function()
{
	var moduleName = 'cla.discuss';

    // Manual singleton as the .service() appears to return multiple instances across Angular apps
    var instance = new TilesService();

	angular.module(moduleName)
	.service('tilesService', ['$http', 'filtersService', 'categoriesService', function($http, filtersService, categoriesService) {
        instance.setHttp($http);
        instance.setFiltersService(filtersService);
        instance.setCategoriesService(categoriesService);

        return instance;
    }]);

	function TilesService()
	{
		var service = this;

        service.$http = null;
        service.filtersService = null;
        service.categoriesService = null;

		service.tiles = discuss_data.tilesBootstrap;
		service.search = '';
		service.order = 'title';
		service.category = 0;
		service.filter = '';
		service.tag = '';
		service.view = 'icon';
		service.newDataCallback = [];

		service.process = function()
		{
			var tiles = [];

			// Merge tiles back into one list if needed
			if (typeof service.tiles.grid !== 'undefined')
			{
				for (var i = 0; i < service.tiles.grid.length; i++)
				{
					tiles.push(service.tiles.grid[i]);
				}
				for (i = 0; i < service.tiles.list.length; i++)
				{
					tiles.push(service.tiles.list[i]);
				}
			} else
			{
				tiles = service.tiles;
			}

			service.tiles =
			{
				grid: [],
				list: []
			};

			for (var j = 0; j < tiles.length; j++)
			{
				if (tiles[j].bookmarked !== null)
				{
					if (service.view !== 'list')
					{
						service.tiles.grid.push(tiles[j]);
					} else
					{
						service.tiles.list.push(tiles[j]);
					}
				} else
				{
					if (service.view === 'icon')
					{
						service.tiles.grid.push(tiles[j]);
					} else
					{
						service.tiles.list.push(tiles[j]);
					}
				}
			}
		};
		service.process();

		service.getTileData = function()
		{
			return service.tiles;
		};

		service.loadTileData = function()
		{
			var search = '';
			if (service.search.length > 0)
				search = 'keywords=' + service.search + '&';

			var filter = '';
			if (service.filter !== '')
				filter = '&filter=' + service.filter;

			var category = '';
			if (service.category > 0)
				category = '&category=' + service.category;

			var tag = '';
			if (service.tag !== '')
				tag = '&tag=' + encodeURI(service.tag);

			var promise = service.$http.get('/intranet/rest/discuss/tiles?' + search + 'order=' + service.order + filter + category + tag)
				.then(function(result)
				{
					service.tiles = result.data.tiles;
					service.process();

                    for (var i = 0; i < service.newDataCallback.length; i++)
                    {
                        service.newDataCallback[i](service.tiles);
                    }

					service.categoriesService.dataCallback(result.data.category_counts);
                    service.filtersService.dataCallback(result.data.filter_counts);
				});
			return promise;
		};

		service.toggleBookmark = function(discuss_id)
		{
			$data = {discuss_id: discuss_id};
			promise = service.$http.post('/intranet/rest/discuss/bookmark', $data)
				.then(function()
				{
					for (var i = 0; i < service.tiles.grid.length; i++)
					{
						if (service.tiles.grid[i].id == discuss_id)
						{
							service.tiles.grid[i].bookmarked = !service.tiles.grid[i].bookmarked;

							if (service.tiles.grid[i].bookmarked)
                                service.filtersService.incrementBookmarks();
							else
                                service.filtersService.decrementBookmarks();
						}
					}
					for (i = 0; i < service.tiles.list.length; i++)
					{
						if (service.tiles.list[i].id == discuss_id)
						{
							service.tiles.list[i].bookmarked = !service.tiles.list[i].bookmarked;

							if (service.tiles.list[i].bookmarked)
                                service.filtersService.incrementBookmarks();
							else
                                service.filtersService.decrementBookmarks();
						}
					}

					service.loadTileData();

				});
			return promise;
		};

		service.setSearch = function(search)
		{
			service.search = search;
			service.loadTileData();
		};

		service.setSort = function(sort)
		{
			service.order = sort;
			service.loadTileData();
		};

		service.setCategory = function(cat)
		{
			service.category = cat;
			service.loadTileData();
		};

		service.setFilter = function(filter)
		{
			service.filter = filter;
			service.loadTileData();
		};

		service.setTag = function(tag)
		{
			service.tag = tag;
			service.loadTileData();
		};

		service.setNewDataCallback = function(callback)
		{
			service.newDataCallback.push(callback);
		};

		service.setView = function(view)
		{
			service.view = view;
			service.process();
            for (var i = 0; i < service.newDataCallback.length; i++)
            {
				service.newDataCallback[i](service.tiles);
            }
		};

        service.setHttp = function($http)
        {
            service.$http = $http;
        };

        service.setFiltersService = function(filtersService)
        {
            service.filtersService = filtersService;
        };

        service.setCategoriesService = function(categoriesService)
        {
            service.categoriesService = categoriesService;
        };
	}
}());
