<?php
$_db_migration_to = '07.01';
if (!isset($migrations) || !is_object($migrations))
	die("This file cannot be executed directly");
$migrations->CheckValid($_db_migration_to);
//===========================================================================================



$migrations->Run('01_migrate_innovate_comments.php', <<<'DB_UPDATE_FILE'
<?php

use Claromentis\Core\DAL;
/** @var $migrations Claromentis\Setup\SetupFacade */


class Migration_Innovate_01MigrateInnovateComments_w2f5q43A
{
	private $delete_old;
	private $db;
	private $data_dir;

	public function __construct(DAL\Db $db, $data_dir, $delete_old = true)
	{
		$this->db = $db;
		$this->data_dir = $data_dir;
		$this->delete_old = $delete_old;
	}

	public function MigrateChannels()
	{
		$res = $this->db->query("SELECT * FROM innovate_channels");
		while ($arr = $res->fetchArray())
		{
			$query = new DAL\QueryInsert('discuss', array(
				'str:title' => $arr['name'],
				'str:description' => 'Imported from Innovate application',
				'int:created_by' => null,
				'int:archived' => 0,
				'int:date_created' => null,
				'int:modified_by' => null,
				'int:modified_date' => null,
			));

			$this->db->query($query);
			$new_discuss_id = $this->db->insertId();

			// transfer permissions for this discussion
			$this->MigrateChannelPermissions($arr['id'], $new_discuss_id);


			$this->MigrateComments($arr['id'], $new_discuss_id);
		}
	}

	public function MigrateChannelPermissions($old_channel_id, $new_discuss_id)
	{
		// non-destructively give correct permissions for the new discussion based on the permissions of the old channel
		// copy view/edit rights as-is, as they are essentially equivalent, though in innovate EDIT is called ADMIN in front end.
		// 82 -> PERM_CLASS_DISCUSS
		// 81 -> PERM_CLASS_INNOVATE
		$res = $this->db->query("SELECT * FROM permissions WHERE class_id=81 AND object_id=int:old_channel_id", $old_channel_id);
		while ($arr= $res->fetchArray())
		{
			$query = new DAL\QueryInsert('permissions', array(
				'int:class_id' => 82,
				'int:object_id' => $new_discuss_id,
				'int:perm_owner_class_id' => $arr['perm_owner_class_id'],
				'int:perm_owner_id' => $arr['perm_owner_id'],
				'int:rights' => $arr['rights'],
			));

			$this->db->query($query);
		}
	}


	public function MigrateComments($old_channel_id, $new_discuss_id)
	{
		$aggregation  = 69; // AGGREGATION_INNOVATE_CHANNEL
		$res = $this->db->query("SELECT * FROM innovate_comments WHERE aggregation=int:aggregation AND object_id=int:channel_id", $aggregation, $old_channel_id);
		while ($arr = $res->fetchArray())
		{
			$this->MigrateComment($arr, $new_discuss_id);
		}

		if ($this->delete_old)
		{
			$this->db->query("DELETE FROM innovate_comments WHERE aggregation=int:aggregation AND object_id=int:channel_id", $aggregation, $old_channel_id);
		}
	}

	private function MigrateComment($comment, $new_discuss_id)
	{
		$query = new DAL\QueryInsert('discussions', array(
			'int:user_id' => $comment['user_id'],
			'int:object_id' => $new_discuss_id,
			'int:ancillary' => null,
			'int:aggregation' => 75, //AGGREGATION_DISCUSS
			'int:parent_id' => 0,
			'int:attachment_id' => null,
			'str:txt' => $comment['txt'],
			'int:timestamp' => $comment['timestamp'],
			'int:like_count' => $comment['like_count'],
			'int:reply_count' => $comment['reply_count'],
		));

		$this->db->query($query);
		$new_comment_id = $this->db->insertId();

		if ($comment['attachment_id'])
		{
			$this->MigrateAttachments($comment['attachment_id'], $new_comment_id);
		}
		$this->MigrateReplies($comment, $new_comment_id, $new_discuss_id);
		$this->MigrateLikes(71, $comment['id'], $new_comment_id);
 	}

 	private function MigrateAttachments($attachment_id, $new_comment_id)
	{
		// attachment types are numbered differently in discuss
		$type_translation_table = array();
		$type_translation_table[1] = 3; // FILE
		$type_translation_table[2] = 2; // INNER DOC
		$type_translation_table[3] = 1; // LINK


		$new_data_dir = $this->data_dir .'/discussion';
		if (!is_dir($new_data_dir))
		{
			mkdir($new_data_dir, 0777);
		}

		$att_res = $this->db->query("SELECT * FROM innovate_attachments WHERE id=int:id", $attachment_id);
		if ($att_res->hasData())
		{
			$att_arr = $att_res->fetchArray();
			if ($att_arr['type'] != 3 && preg_match('/\.([\w\d_]+)$/', $att_arr['name'], $matches))
			{
				$extension = $matches[1];
				// remove the extension from the filename
				$att_arr['name'] = preg_replace('/\.[\w\d_]+$/', '', $att_arr['name']);
			}
			else
			{
				$extension = '';
			}
			$query = new DAL\QueryInsert('discussion_attachments', array(
				'int:discussion_id' => $new_comment_id,
				'int:doc_id' => $att_arr['doc_id'],
				'str:name' => $att_arr['type'] == 3 ? $att_arr['path'] : $att_arr['name'], // if a link, set name to url, else filename
				'str:extension' => $extension,
				'str:path' => $att_arr['path'],
				'int:type' => $type_translation_table[intval($att_arr['type'])],
			));

			$this->db->query($query);
			$new_attachment_id = $this->db->insertId();

			$this->MigrateAttachmentFile($attachment_id, $new_attachment_id);
			$this->MigrateAttachmentFile($attachment_id.'_large', $new_attachment_id.'_lg');
			$this->MigrateAttachmentFile($attachment_id.'_thumb', $new_attachment_id.'_sm');

			if ($this->delete_old)
			{
				$this->db->query("DELETE FROM innovate_attachments WHERE id=int:id", $attachment_id);
			}
		}
	}

 	private function MigrateAttachmentFile($old_name, $new_name)
	{
		$new_data_dir = $this->data_dir.'/discussion';
		$innovate_data_dir = $this->data_dir.'/innovate/attachments';

		if (is_file($innovate_data_dir.'/'.$old_name.'.dat'))
		{
			if ($this->delete_old)
			{
				rename($innovate_data_dir.'/'.$old_name.'.dat', $new_data_dir.'/'.$new_name.'.dat');
			}
			else
			{
				copy($innovate_data_dir.'/'.$old_name.'.dat', $new_data_dir.'/'.$new_name.'.dat');
			}
		}
	}

 	private function MigrateReplies($old_comment_info, $new_comment_id, $new_discuss_id)
	{
		$old_comment_id = $old_comment_info['id'];
		$res = $this->db->query("SELECT * FROM innovate_replies WHERE comment_id=int:id", $old_comment_id);
		if ($res->hasData())
		{
			while ($arr = $res->fetchArray())
			{
				$query = new DAL\QueryInsert('discussions', array(
					'int:user_id' => $arr['user_id'],
					'int:object_id' => $new_discuss_id,
					'int:ancillary' => null,
					'int:aggregation' => 75, //AGGREGATION_DISCUSS
					'int:parent_id' => $new_comment_id,
					'int:attachment_id' => null,
					'str:txt' => $arr['txt'],
					'int:timestamp' => $arr['timestamp'],
					'int:like_count' => 0,
					'int:reply_count' => 0,
				));

				$this->db->query($query);
				$new_reply_id = $this->db->insertId();
				$this->MigrateLikes(72, $arr['id'], $new_reply_id);
			}
		}
		if ($this->delete_old)
		{
			$this->db->query("DELETE FROM innovate_replies WHERE comment_id=int:id", $old_comment_id);
		}
	}


	private function MigrateLikes($aggregation, $old_object_id, $new_object_id)
	{
		// get all the likes for this comment and move them to the likes table
		$res = $this->db->query("SELECT * FROM innovate_likes WHERE object_id=int:old_object_id AND aggregation=int:aggregation", $old_object_id, $aggregation);
		if ($res->hasData())
		{
			while ($arr = $res->fetchArray())
			{
				$query = new DAL\QueryInsert('likes', array(
					'int:user_id' => $arr['user_id'],
					'int:object_id' => $new_object_id,
					'int:aggregation' => 132,  // AGGREGATION_COMMENT
					'int:timestamp' => $arr['timestamp'],
				));

				$this->db->query($query);
			}
		}

		// delete if necessary.
		if ($this->delete_old)
		{
			$this->db->query("DELETE FROM innovate_likes WHERE aggregation=int:aggregation AND object_id=int:old_object_id",
				$aggregation, $old_object_id);
		}

	}
}

$db = $migrations->GetDb();

$delete_old = false;


/** @var Claromentis\Core\Plugin\PluginsRepository $plugins_repo */
$plugins_repo = $migrations->GetPluginsRepository();

// only run migration if innovate plugin installed.
if ($plugins_repo->Exists('innovate'))
{
	$comments_migrator = new Migration_Innovate_01MigrateInnovateComments_w2f5q43A($db, $migrations->GetDataDir(), $delete_old);
	// recursively migrate channels, comments, attachments, replies and likes
	$comments_migrator->MigrateChannels();
}


DB_UPDATE_FILE
);


//===========================================================================================
$migrations->SetVersion('07.01');
