(function()
{
	var moduleName = 'cla.discuss';

	angular
		.module(moduleName)
		.controller('contributorsController', ['contributorsService', contributorsController]);

	function contributorsController(dataSrc)
	{
		var ctrl = this;
		ctrl.dataSrc = dataSrc;

		ctrl.contributors = ctrl.dataSrc.getContributorData();
		ctrl.total = ctrl.dataSrc.getContributorTotal();
		ctrl.is_more = (ctrl.total > ctrl.contributors.length);
		ctrl.dataSrc.loadContributorData(true)
		.then(function()
		{
			ctrl.contributors = ctrl.dataSrc.getContributorData();
			ctrl.total = ctrl.dataSrc.getContributorTotal();
			ctrl.is_more = (ctrl.total > ctrl.contributors.length);
		});

		ctrl.showAll = function($event)
		{
			$event.preventDefault();
			ctrl.dataSrc.loadContributorData(false)
			.then(function()
			{
				ctrl.contributors = ctrl.dataSrc.getContributorData();
				ctrl.total = ctrl.dataSrc.getContributorTotal();
				ctrl.is_more = (ctrl.total > ctrl.contributors.length);
			});
		};
	}
}());