(function()
{
	var moduleName = 'cla.discuss';

	angular.module(moduleName)
	.controller('taskFilterController', ['tasksService', taskFilter_controller]);

	function taskFilter_controller(service)
	{
		var ctrl = this;
		ctrl.service = service;

		ctrl.showCompleted = false;
		ctrl.priority = null;
		ctrl.assigned = {assigned_value: ''};
		ctrl.dueDate = '';

		angular.element('#filterPriority').select2(
		{
			width: '100%',
			templateResult: function(data)
			{
				return $('<span class="' + data.text + '"></span>');
			},
			templateSelection: function(data)
			{
				if (data.id === '')
					return data.text;

				return $('<span class="' + data.text + '"></span>');
			},
			allowClear: true,
			placeholder: lmsg('discuss.tasks.priority'),
			minimumResultsForSearch: Infinity // Hide search box
		});

		angular.element('#filterDueDate').select2(
			{
				width: '100%',
				allowClear: true,
				placeholder: lmsg('discuss.tasks.due_date'),
				minimumResultsForSearch: Infinity // Hide search box
			});

		ctrl.filterCompleted = function()
		{
			ctrl.service.setFilterCompleted(ctrl.showCompleted);
		};

		ctrl.filterPriority = function()
		{
			if (ctrl.priority == '')
			{
				angular.element('#filterPriority').val(null);
				setTimeout(function(){angular.element('#filterPriority').change()}, 0);
			}
			ctrl.service.setFilterPriority(ctrl.priority);
		};

		ctrl.filterAssigned = function()
		{
			ctrl.service.setFilterAssigned(ctrl.assigned.assigned_value);
		};

		ctrl.filterDueDate = function()
		{
			ctrl.service.setFilterDueDate(ctrl.dueDate);
		};
	}
}());
