(function()
{
	var moduleName = 'cla.core';
	try {
		module = angular.module(moduleName);
	} catch(err) {
		// named module does not exist, so create one
		module = angular.module(moduleName, []);
	}

	angular.module(moduleName)
	.directive('claTimePicker', timePicker);

	function timePicker() {
		return {
			restrict: 'E',
			require: '^ngModel',
			templateUrl: '/intranet/discuss/html/directives/time_picker.html',
			scope: {
				ngModel: '='
			},
			link: function(scope, iElement, iAttrs, ctrl)
			{
				scope.id = iAttrs.id;
				scope.name = iAttrs.name;
				scope.ctrl = ctrl;

				// Allow the value to be overridden
				scope.value = iAttrs.value;
				if ((typeof scope.value !== 'undefined') &&
					(scope.ngModel === 'xx:xx'))
				{
					scope.ngModel = scope.value;
				}

				ctrl.$viewChangeListeners.push(function() {
					scope.$eval(iAttrs.ngChange);
				});

				scope.clickTime = function(event)
				{
					event.preventDefault();
					var options =
					{
						'scrollDefault': 'now',
						'maxTime': '23:59'
					};
					angular.element(scope.id + '-inner').data('time_picker_initialized', 1).timepicker(options).timepicker('show');
				};
			}
		};
	}
}());