(function()
{
	var moduleName = 'cla.discuss';

	angular.module(moduleName)
	.service('contributorsService', ['$http', '$q', 'discuss.datasource', contributorsService]);

	function contributorsService($http, $q, dataSrc)
	{
		var service = this;

		service.dataSrc = dataSrc;

		service.commonData = dataSrc.getCommonData();
		service.contributors = [];
		service.total = 0;

		service.loadContributorData = function(limited)
		{
			// Use data provided by the server if there is any, then invalidate it
			if (contributors_data != null)
			{
				service.contributors = contributors_data.contributors;
				service.total = contributors_data.total;
				contributors_data = null;
				return $q.when(null);
			}

			var limit = '';
			if (!limited)
				limit = '/all';
			var promise = $http.get('/intranet/rest/discuss/contributors/' + service.commonData.id + limit)
			.then(function(result)
			{
				if (result.status === 200)
				{
					service.contributors = result.data.contributors;
					service.total = result.data.total;
				}
			});

			return promise;
		};


		service.getContributorData = function()
		{
			return service.contributors;
		};

		service.getContributorTotal = function()
		{
			return service.total;
		};
	}
}());