(function()
{
	var moduleName = 'cla.discuss';

	angular.module(moduleName)
	.service('eventsService', ['$http', '$q', 'discuss.data.infopanel', 'growl.service', eventsService]);

	function eventsService($http, $q, infopanel_service, growl)
	{
		var service = this;

		service.infopanel = infopanel_service;
		service.growl = growl;

		service.commonData =
		{
			title: discuss_data.title,
			id: discuss_data.id,
			aggregation: discuss_data.aggregation,
			aggregation_name: discuss_data.aggregation_name
		};

		service.events = [];
		service.pending_events = [];

		/*
		 * COMMON
		 */
		service.setCommonData = function(data)
		{
			service.common = data;
		};

		service.getCommonData = function()
		{
			return service.commonData;
		};

		/*
		 * Events
		 */
		service.loadEventData = function()
		{
			// Use data provided by the server if there is any, then invalidate it
			if (events_data != null)
			{
				service.events = events_data;
				events_data = null;
				return $q.when(null);
			}

			var promise = $http.get('/intranet/rest/discuss/events/' + service.commonData.id)
			.then(function(result)
			{
				if (result.status === 200)
					service.events = result.data;
			});

			return promise;
		};

		service.loadPendingEventData = function()
		{
			// Use data provided by the server if there is any, then invalidate it
			if (pending_events_data != null)
			{
				service.pending_events = pending_events_data;
				pending_events_data = null;
				return $q.when(null);
			}

			var promise = $http.get('/intranet/rest/discuss/pending_events/' + service.commonData.id)
			.then(function(result)
			{
				if (result.status === 200)
					service.pending_events = result.data;
			});

			return promise;
		};

		service.addEvent = function(data)
		{
			var promise = $http.post('/intranet/rest/discuss/event/' + service.commonData.id, data)
			.then(function()
			{
				service.infopanel.modifyData('events', 1);
			}, function(result)
			{
				service.growl.showError(result.data, '');
			});

			return promise;
		};

		service.editEvent = function(data)
		{
			var promise = $http.put('/intranet/rest/discuss/event/' + data.id, data);

			return promise;
		};

		service.getEventData = function()
		{
			return service.events;
		};

		service.getPendingEventData = function()
		{
			return service.pending_events;
		};

		service.getSingleEventData = function(event_id)
		{
			var event = null;
			for (var i = 0; i < service.events.length; i++)
			{
				if (service.events[i].id == event_id)
					event = service.events[i];
			}

			return event;
		};

		service.deleteEvent = function(event_id)
		{
			$http.delete('/intranet/rest/discuss/event/' + event_id)
			.then(function()
			{
				service.infopanel.modifyData('events', -1)
			});

			// Find the event id if it exists
			var index = -1;
			for (var i = 0; i < service.events.length; i++)
			{
				if (service.events[i].id == event_id)
					index = i;
			}

			// Remove that entry if found
			if (index > -1)
				service.events.splice(index, 1);
		};
	}
}());
