(function()
{
	var moduleName = 'cla.discuss';

	angular.module(moduleName)
	.service('subscriptionService', subscriptionService);

	subscriptionService.$inject = ['$http'];
	function subscriptionService($http)
	{
		var service = this;

		service.unsubscribe = function(id, successCallback, failureCallback)
		{
            $http.post('/api/discuss/unsubscribe/' + id).then(function (response) {
                if(response.data.success && !response.data.subscribed)
                    successCallback();
                else
                    failureCallback();
            }, function(){
                failureCallback();
            });
		};

		service.subscribe = function(id, successCallback, failureCallback)
		{
            $http.post('/api/discuss/subscribe/' + id).then(function (response) {
                if(response.data.success && response.data.subscribed)
                    successCallback();
                else
                    failureCallback();
            }, function(){
                failureCallback();
            });
		};
	}
}());