(function()
{
	var moduleName = 'cla.discuss';

	angular.module(moduleName)
	.controller('filtersController', ['$scope', '$timeout', 'filtersService', 'tilesService', filters_controller]);

	function filters_controller($scope, $timeout, filtersService, tilesService)
	{
		var ctrl = this;
		ctrl.filtersService = filtersService;
		ctrl.tilesService = tilesService;

		ctrl.filters = ctrl.filtersService.getFilterData();
		ctrl.current = 'all';

		// data callback for data updates
		ctrl.dataCallback = function (filter_counts)
		{
			for (var i in ctrl.filters)
				ctrl.filters[i].count = filter_counts[ctrl.filters[i].key];

            $timeout(function(){
                $scope.$digest();
            }, 0);
		};
		ctrl.filtersService.setDataCallback(ctrl.dataCallback);

		ctrl.setFilter = function($event, filter)
		{
			$event.preventDefault();

			ctrl.current = filter;
			ctrl.tilesService.setFilter(ctrl.current);
		};
	}
}());
