(function()
{
	var moduleName = 'cla.discuss';

	angular.module(moduleName)
	.controller('tilesController', ['$scope', '$timeout', 'tilesService', tiles_controller]);

	function tiles_controller($scope, $timeout, service)
	{
		var ctrl = this;
		ctrl.service = service;

		ctrl.tiles = ctrl.service.getTileData();

		ctrl.newDataCallback = function(newData)
		{
			ctrl.tiles = newData;
            $timeout(function(){
                $scope.$digest();
            }, 0);
		};
		ctrl.service.setNewDataCallback(ctrl.newDataCallback);

		ctrl.toggleBookmark = function($event, discuss_id)
		{
			angular.element('#bookmark-' + discuss_id).tooltip('hide');
			$event.preventDefault();
			ctrl.service.toggleBookmark(discuss_id);
		};
	}
}());
