<?php
// This file contains the database schema version 15.01
if (!isset($migrations) || !is_object($migrations))
	die("This file cannot be executed directly");
if ($migrations->GetVersion() > 0)
	throw new Exception("The database is already initialized");
//===========================================================================================

// discuss
$table_descr = array(
	'id'	=>	"IDENTITY",
	'title'	=>	"VARCHAR(255) NULL",
	'description'	=>	"VARCHAR_MAX NULL",
	'created_by'	=>	"INT NULL",
	'archived'	=>	"INT NULL DEFAULT 0",
	'date_created'	=>	"INT_DATE NULL",
	'modified_by'	=>	"INT NULL",
	'modified_date'	=>	"INT_DATE NULL",
);

$db->CreateTable('discuss', $table_descr, true);
$db->CreateIndex('discuss', 'idx_id_title_created_by_date_created_index', 'id', 'title', 'created_by', 'date_created');



// discuss_bookmark
$table_descr = array(
	'id'	=>	"IDENTITY",
	'user_id'	=>	"INT NULL",
	'discuss_id'	=>	"INT NULL",
);

$db->CreateTable('discuss_bookmark', $table_descr, true);
$db->CreateIndex('discuss_bookmark', 'idx_discuss_id_user_id', 'discuss_id', 'user_id');



// discuss_category
$table_descr = array(
	'id'	=>	"IDENTITY",
	'name'	=>	"VARCHAR_MAX NULL",
	'created_by'	=>	"INT NULL",
	'created_date'	=>	"INT_DATE NULL",
);

$db->CreateTable('discuss_category', $table_descr, true);



// discuss_category_subscription
$table_descr = array(
	'discuss_id'	=>	"INT NULL",
	'category_id'	=>	"INT NULL",
);

$db->CreateTable('discuss_category_subscription', $table_descr, true);



// discuss_contributor
$table_descr = array(
	'id'	=>	"IDENTITY",
	'discuss_id'	=>	"INT NULL",
	'user_id'	=>	"INT NULL",
	'timestamp'	=>	"INT_DATE NULL",
	'uidx'	=>	"VARCHAR(100) NULL",
	'subscribed'	=>	"BOOL NOT_NULL DEFAULT 1",
);

$db->CreateTable('discuss_contributor', $table_descr, true);
$db->CreateIndex('discuss_contributor', 'idx_discuss_id', 'discuss_id');



// discuss_event
$table_descr = array(
	'id'	=>	"IDENTITY",
	'discuss_id'	=>	"INT NULL",
	'title'	=>	"VARCHAR(255) NULL",
	'date_start'	=>	"INT_DATE NULL",
	'date_end'	=>	"INT_DATE NULL",
	'created_by'	=>	"INT NULL",
	'created_date'	=>	"INT_DATE NULL",
	'modified_by'	=>	"INT NULL",
	'modified_date'	=>	"INT_DATE NULL",
);

$db->CreateTable('discuss_event', $table_descr, true);
$db->CreateIndex('discuss_event', 'idx_discuss_id', 'discuss_id');



// discuss_note
$table_descr = array(
	'id'	=>	"IDENTITY",
	'discuss_id'	=>	"INT NULL",
	'title'	=>	"VARCHAR(255) NULL",
	'text'	=>	"CLOB NULL",
	'created_by'	=>	"INT NULL",
	'created_date'	=>	"INT_DATE NULL",
	'modified_by'	=>	"INT NULL",
	'modified_date'	=>	"INT_DATE NULL",
);

$db->CreateTable('discuss_note', $table_descr, true);
$db->CreateIndex('discuss_note', 'idx_discuss_id', 'discuss_id');



// discuss_subscription
$table_descr = array(
	'discuss_id'	=>	"INT NOT_NULL DEFAULT 0",
	'user_id'	=>	"INT NOT_NULL DEFAULT 0",
);

$db->CreateTable('discuss_subscription', $table_descr, true);
$db->CreateIndex('discuss_subscription', 'idx_subscription_discuss', 'discuss_id');
$db->CreateIndex('discuss_subscription', 'idx_subscription_user', 'user_id');
$db->CreateIndex('discuss_subscription', 'idx_subscription_discuss_user', 'discuss_id', 'user_id');





//===========================================================================================
$migrations->SetVersion('15.01');
