(function()
{
	var moduleName = 'cla.discuss';

	angular
		.module(moduleName)
		.controller('subscriptionController', subscriptionController);

	subscriptionController.$inject = ['$scope', '$timeout', 'subscriptionService', 'growl.service'];
	function subscriptionController($scope, $timeout, service, growl)
	{
		var ctrl = this;
		ctrl.is_subscribed = window.discuss_data.is_subscribed;
		ctrl.is_participant = window.discuss_data.is_participant;
		ctrl.is_processing = false;
		ctrl.discussion_id = window.discuss_data.id;

        ctrl._onNewComment = function()
        {
            ctrl.is_subscribed = true;
            ctrl.is_participant = true;

            $timeout(function()
            {
                $scope.$digest();
            }, 0);
        };
		$scope.$on('cla.comments.comment_added', ctrl._onNewComment);
        $scope.$on('cla.comments.reply_added', ctrl._onNewComment);

        ctrl.unsubscribe = function($event) {
            $event.preventDefault();
            angular.element('#unsubscribe-link').tooltip('hide');
            ctrl.is_processing = true;
            var successCallback = function(){
                growl.showSuccess(lmsg("discuss.discussion.muted_this_discussion"));
                ctrl.is_subscribed = false;
                ctrl.is_processing = false;
            };

            var failureCallback = function(){
                growl.showError(lmsg("discuss.discussion.could_not_mute"));
                ctrl.is_processing = false;
            };
			service.unsubscribe(ctrl.discussion_id, successCallback, failureCallback);
        };

        ctrl.subscribe = function($event) {
            $event.preventDefault();
            angular.element('#subscribe-link').tooltip('hide');
            ctrl.is_processing = true;
            var successCallback = function(){
                growl.showSuccess(lmsg("discuss.discussion.unmuted_this_discussion"));
                ctrl.is_subscribed = true;
                ctrl.is_processing = false;
                ctrl.is_participant = true;
			};
            var failureCallback = function(){
                growl.showError(lmsg("discuss.discussion.could_not_unmute"));
                ctrl.is_processing = false;
			};
            service.subscribe(ctrl.discussion_id, successCallback, failureCallback);
        };
	}
}());