(function()
{
	var moduleName = 'cla.discuss';

	angular.module(moduleName)
	.directive('taskEdit', taskEdit);

	taskEdit.$inject = ['tasksService', '$timeout'];
	function taskEdit(service, $timeout)
	{
		var controller = function()
		{
			var ctrl = this;
            ctrl.service = service;

            this.$onInit = function() {
                ctrl.copyEditData();

                $timeout(function(id)
                {
                    angular.element('#priorityFlag-' + id).select2(
                        {
                            templateResult: function(data)
                            {
                                return $('<span class="' + data.text + '"></span>');
                            },
                            templateSelection: function(data)
                            {
                                return $('<span class="' + data.text + '"></span>');
                            },
                            minimumResultsForSearch: Infinity // Hide search box
                        });
                    angular.element('#repeatPeriod-' + id).select2(
                        {
                            minimumResultsForSearch: Infinity // Hide search box
                        });
                    angular.element('#task_due_date-' + ctrl.editData.id)
                        .datetimepicker(
                            {
                                format: cla_locale.date_format
                            })
                        .on('dp.change', function (e)
                        {
                            angular.element(this).trigger('change');
                        });
                }, 0, false, ctrl.task.id);
            };

			ctrl.copyEditData = function()
			{
				// Clone the data to avoid references
				ctrl.editData = angular.element.extend({}, ctrl.task);

				ctrl.editData.priority = ctrl.editData.priority.toString();
				ctrl.editData.assigned_value = null;

				ctrl.editData.assigned_ngModel =
				{
					assigned_value: null,
					assigned_str: ''
				};

				if (ctrl.editData.assigned !== null)
				{
					ctrl.editData.assigned_ngModel.assigned_value = ctrl.editData.assigned_oclass + '_' + ctrl.editData.assigned;
					ctrl.editData.assigned_ngModel.assigned_str = ctrl.editData.assigned_str;
				}
			};

			ctrl.cancelEdit = function($event)
			{
				$event.preventDefault();

				ctrl.task.isEdit = false;
				ctrl.copyEditData();
			};

			ctrl.save = function($event)
			{
				$event.preventDefault();

				ctrl.editData.assigned = ctrl.editData.assigned_ngModel.assigned_value;

				ctrl.service.save(angular.element.extend({}, ctrl.editData))
				.then(function()
				{
					ctrl.task = ctrl.editData;
					ctrl.task.isEdit = false;
				});
			};
		};

		return {
			restrict: 'E',
			templateUrl: '/intranet/discuss/html/directives/taskedit.html',
			scope:
			{
				task: '='
			},
			controllerAs: 'task',
			bindToController: true,
			controller: controller
		};
	}
}());
