(function()
{
	var moduleName = 'cla.discuss';

	angular.module(moduleName)
	.service('discuss.datasource', ['$http', '$q', 'discuss.data.infopanel', 'growl.service', function($http, $q, infopanel_service, growl)
	{
		var service = this;

		service.infopanel = infopanel_service;
		service.growl = growl;

		service.commonData =
		{
			title: discuss_data.title,
			description: discuss_data.description,
			is_admin: discuss_data.is_admin,
			is_archived: discuss_data.is_archived,
			id: discuss_data.id,
			aggregation: discuss_data.aggregation,
			aggregation_name: discuss_data.aggregation_name,
			created: discuss_data.created,
			modified: discuss_data.modified,
			metadata: discuss_data.metadata,
			tags: discuss_data.tags,
			myTasks: discuss_data.my_tasks
		};

		service.notes = [];
		service.links = [];
		service.files = [];

		/*
		 * COMMON
		 */
		service.setCommonData = function(data)
		{
			service.common = data;
		};

		service.getCommonData = function()
		{
			return service.commonData;
		};

		service.getTagsData = function()
		{
			return service.commonData.tags;
		};

		service.getMyTasksData = function()
		{
			return service.commonData.myTasks;
		};

		/*
		 * NOTES
		 */
		service.loadNoteData = function()
		{
			// Use data provided by the server if there is any, then invalidate it
			if (notes_data != null)
			{
				service.notes = notes_data;
				notes_data = null;
				return $q.when(null);
			}

			var promise = $http.get('/intranet/rest/discuss/notes/' + service.commonData.id)
			.then(function(result)
			{
				if (result.status === 200)
					service.notes = result.data;
			});

			return promise;
		};

		service.addNote = function(data)
		{
			var sendData =
			{
				title: data.title,
				text: data.note,
				discuss_id: service.commonData.id
			};
			var promise = $http.post('/intranet/rest/discuss/note/' + service.commonData.id, sendData)
			.then(function()
			{
				service.infopanel.modifyData('notes', 1);
			}, function(result)
			{
				service.growl.showError(result.data, '');
			});

			return promise;
		};

		service.editNote = function(data)
		{
			var sendData =
			{
				title: data.title,
				text: data.note
			};
			var promise = $http.put('/intranet/rest/discuss/note/' + data.id, sendData);

			return promise;
		};

		service.getNoteData = function()
		{
			return service.notes;
		};

		service.getSingleNoteData = function($note_id)
		{
			var note = null;
			for (var i = 0; i < service.notes.length; i++)
			{
				if (service.notes[i].id == $note_id)
					note = service.notes[i];
			}

			return note;
		};

		service.deleteNote = function(note_id)
		{
			$http.delete('/intranet/rest/discuss/note/' + note_id)
			.then(function()
			{
				service.infopanel.modifyData('notes', -1)
			});

			// Find the note id if it exists
			var index = -1;
			for (var i = 0; i < service.notes.length; i++)
			{
				if (service.notes[i].id == note_id)
					index = i;
			}

			// Remove that entry if found
			if (index > -1)
				service.notes.splice(index, 1);
		};

		/*
		 * LINKS
		 */
		service.loadLinkData = function()
		{
			// Use data provided by the server if there is any, then invalidate it
			if (links_data != null)
			{
				service.links = links_data;
				links_data = null;
				return $q.when(null);
			}

			var promise = $http.get('/intranet/rest/discuss/links/' + service.commonData.id)
				.then(function(result)
				{
					if (result.status === 200)
						service.links = result.data;
				});

			return promise;
		};

		service.getLinkData = function()
		{
			return service.links;
		};

		/*
		 * FILES
		 */
		service.loadFileData = function()
		{
			// Use data provided by the server if there is any, then invalidate it
			if (files_data != null)
			{
				service.files = files_data;
				files_data = null;
				return $q.when(null);
			}

			var promise = $http.get('/intranet/rest/discuss/files/' + service.commonData.id)
				.then(function(result)
				{
					if (result.status === 200)
						service.files = result.data;
				});

			return promise;
		};

		service.getFileData = function()
		{
			return service.files;
		};
	}]);
}());
