(function()
{
	var moduleName = 'cla.discuss';

	angular.module(moduleName)
	.service('filtersService', filters_service);

	function filters_service()
	{
		var service = this;

		service.filters = discuss_data.sideFilters;
		service.dataCallbackFunc = null;

		service.getFilterData = function()
		{
			return service.filters;
		};

		service.dataCallback = function(args)
		{
			if (service.dataCallbackFunc !== null)
				service.dataCallbackFunc(args);
		};

		service.setDataCallback = function(func)
		{
			service.dataCallbackFunc = func;
		};

		service.incrementBookmarks = function()
		{
			for (var i = 0; i < service.filters.length; i++)
			{
				if (service.filters[i].key === 'bookmarked')
					service.filters[i].count++;
			}
		};

		service.decrementBookmarks = function()
		{
			for (var i = 0; i < service.filters.length; i++)
			{
				if (service.filters[i].key === 'bookmarked')
					service.filters[i].count--;
			}
		};
	}
}());