// A view wrapping the DMSV component
// ----------------------------------

define(['../dms_view.js', 'backbone'], function(DMSV, Backbone)
{
	DMSV.prototype.ContainerView = Backbone.View.extend({
		initialize: function(options) {
			this.options = options;
			_.bindAll(this, "render", "renderAppend", "renderRemove", "error");
			this.options.instance.objectCollection.on("add", this.renderAppend);
			this.options.instance.objectCollection.on("remove", this.renderRemove);
			this.options.instance.objectCollection.on("reset", this.render);
			this.options.instance.objectCollection.on("error", this.error);
		},

		appendOne: function(model) {
			// Some error checking.
			// This seems to happen when the Cla Indexing service is not running
			if (model.has("success") && model.get("success") === false) {
				alert("Sorry! There was an error communicating with the server");
				return false;
			}

			if(model.get("type") === "folder") {
				this.$el.append(new this.options.instance.FolderView({ model: model, instance: this.options.instance }).render().el);
			} else if(model.get("type") === "document") {
				if (model.get('is_draft') == 0)
					this.$el.append(new this.options.instance.DocumentView({ instance: this.options.instance, model: model }).render().el);
			} else { // We should never get here
				alert("ERROR: An unknown object type was received in DMSV.ContainerView.appendOne() - Type: " + model.get("type"));
			}
		},

		renderAppend: function (object) {
			if (this.options.instance.objectCollection.length <= 1)
				this.render();
			else
				this.appendOne(object);
		},

		renderRemove: function () {
			if (this.options.instance.objectCollection.length === 0)
				this.render();
		},

		render: function() {
			this.$el.empty();
			this.options.instance.objectCollection.each(function(object) {
				this.appendOne(object);
			}, this);

			if(this.options.instance.objectCollection.length === 0) {
				this.$el.append(lmsg('dmsv.no_documents_in_folder')).addClass("text-muted");
			}
		},

		error: function(collection, response) {

			var errMsg = response.status + " : " + response.responseText;

			if(response.status == 403)
				errMsg ="You don't have permissions to view this folder!";

			var errMsgContainer = $("<div>").addClass("alert alert-error").append('<strong>ERROR</strong><br>').append(errMsg);

			this.$el.html(errMsgContainer);

			// remove breadcrumbs ,view in documents link & disable search
			this.options.instance.breadcrumbView.$el.hide();
			this.options.instance.viewInDMSView.$el.hide();
			this.options.instance.searchView.$el.find('input').attr('readonly', true);

			return false;
		}
	});

	return DMSV;
});
