define(['jquery'], function($)
{
	var DMSV = function(){};
	DMSV.prototype.constant = {
		FOLDER: 2,
		DOCUMENT: 4
	};

	// Our current folder
	DMSV.prototype.activeFolder = 0;
	// The desired root folder
	DMSV.prototype.rootFolder = 0;

	DMSV.prototype.activeFolderObj = undefined;

	DMSV.prototype.create = function (prefix) {
		var rootElement = $('#dmsv-instance-' + prefix);
		var listEl = rootElement.find('.js-dmsv-container');

		this.styleSwitchView = new this.StyleSwitchView({el: rootElement.find('.js-view-style'), listEl: listEl, rootFolder: this.rootFolder});
		this.addFolderView = new this.CreateFolderView({el: '#addFolderPopup', prefix: prefix, instance: this});
		this.addDocumentView = new this.AddDocumentView({el: '#addDocumentPopup', prefix: prefix, instance: this});
		this.addDocumentModalView = new this.AddDocumentModalView({el: '.js-add-docs', instance: this});

		// Search stuff
		this.search = new this.Search();
		this.searchView = new this.SearchView({ el: rootElement.find('.js-search_form'), prefix: prefix, model: this.search, instance: this });

		this.objectCollection = new this.ObjectCollection({prefix: prefix, instance: this, spinner: rootElement.find('.js-docSpinner')});
		this.containerView = new this.ContainerView({el: listEl, instance: this });
		this.objectCollection.fetch();

		this.breadcrumbCollection = new this.BreadcrumbCollection({instance: this});
		this.breadcrumbView = new this.BreadcrumbView({el: rootElement.find('.js-dmsv-breadcrumb'), instance: this, collection: this.breadcrumbCollection });
		this.breadcrumbCollection.fetch();

		this.addFolderDocumentButtons = new this.AddFolderDocumentButtons({el: rootElement.find('.js-add-folder-docs-btns'), root_edit: this.options.root_edit, prefix: prefix, instance: this});
		this.addFolderDocumentButtons.redraw();
		this.viewInDMSView = new this.ViewInDMSView({el: rootElement.find('.js-view-in-dms'), instance: this});

		this.showMoreView = new this.ShowMoreView({el: rootElement.find('.js-show-more'), prefix: prefix, instance: this});
		this.showMoreView.render();

		// temporary changes for buttons in popup forms
		this.detailedUploadView = new this.DetailedUploadView({el: rootElement.find('.js-addDocumentPopup'), instance: this});
		this.extendedEditView = new this.ExtendedEditView({el: '#addFolderPopup', instance: this});

		this.options.$addDocumentPopup = rootElement.find('#add_doc_form');

		this.options.addDocumentUrl = '/intranet/documents/add_doc.php';
		this.options.$addDocumentButton = rootElement.find(".js-dmsv-add-document-link");
	};

	return DMSV;
});
